/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsShelveUtils {
    private static final Logger LOG = Logger.getInstance((String)VcsShelveUtils.class.getName());

    public static void doSystemUnshelve(Project project, ShelvedChangeList shelvedChangeList, @Nullable LocalChangeList targetChangeList, ShelveChangesManager shelveManager, @Nullable String leftConflictTitle, @Nullable String rightConflictTitle) {
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        String projectPath = baseDir.getPath() + "/";
        LOG.info("refreshing files ");
        VcsShelveUtils.refreshFilesBeforeUnshelve(project, shelvedChangeList, projectPath);
        LOG.info("Unshelving shelvedChangeList: " + shelvedChangeList);
        List<ShelvedChange> changes2 = shelvedChangeList.getChanges(project);
        shelveManager.unshelveChangeList(shelvedChangeList, changes2, shelvedChangeList.getBinaryFiles(), targetChangeList, false, true, true, leftConflictTitle, rightConflictTitle, true);
        ApplicationManager.getApplication().invokeAndWait(() -> VcsShelveUtils.markUnshelvedFilesNonUndoable(project, changes2));
    }

    private static void markUnshelvedFilesNonUndoable(@NotNull Project project, @NotNull List<? extends ShelvedChange> changes2) {
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)project);
        if (undoManager != null && !changes2.isEmpty()) {
            ContainerUtil.process(changes2, change -> {
                VirtualFile vfUnderProject = VfsUtil.findFileByIoFile((File)new File(project.getBasePath(), change.getAfterPath()), (boolean)false);
                if (vfUnderProject != null) {
                    DocumentReference documentReference = DocumentReferenceManager.getInstance().create(vfUnderProject);
                    undoManager.nonundoableActionPerformed(documentReference, false);
                    undoManager.invalidateActionsFor(documentReference);
                }
                return true;
            });
        }
    }

    private static void refreshFilesBeforeUnshelve(Project project, ShelvedChangeList shelvedChangeList, String projectPath) {
        HashSet<File> filesToRefresh = new HashSet<File>();
        for (ShelvedChange c : shelvedChangeList.getChanges(project)) {
            if (c.getBeforePath() != null) {
                filesToRefresh.add(new File(projectPath + c.getBeforePath()));
            }
            if (c.getAfterPath() == null) continue;
            filesToRefresh.add(new File(projectPath + c.getAfterPath()));
        }
        for (ShelvedBinaryFile f : shelvedChangeList.getBinaryFiles()) {
            if (f.BEFORE_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.BEFORE_PATH));
            }
            if (f.AFTER_PATH == null) continue;
            filesToRefresh.add(new File(projectPath + f.AFTER_PATH));
        }
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
    }

    @Nullable
    public static ShelvedChangeList shelveChanges(Project project, ShelveChangesManager shelveManager, Collection<? extends Change> changes2, String description, List<? super VcsException> exceptions, boolean rollback, boolean markToBeDeleted) {
        try {
            ShelvedChangeList shelve = shelveManager.shelveChanges(changes2, description, rollback, markToBeDeleted);
            BackgroundTaskUtil.syncPublisher(project, ShelveChangesManager.SHELF_TOPIC).stateChanged(new ChangeEvent(VcsShelveUtils.class));
            return shelve;
        }
        catch (IOException e) {
            exceptions.add(new VcsException("Shelving changes failed: " + description, (Throwable)e));
            return null;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return null;
        }
    }
}

