/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J+\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction;", "Lcom/intellij/openapi/vcs/actions/AbstractCommonCheckinAction;", "()V", "approximatelyHasRoots", "", "dataContext", "Lcom/intellij/openapi/vcs/actions/VcsContext;", "disableIfAnyHijackedChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/actionSystem/Presentation;[Lcom/intellij/openapi/vcs/changes/Change;)V", "getRoots", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/actions/VcsContext;)[Lcom/intellij/openapi/vcs/FilePath;", "update", "vcsContext", "intellij.platform.vcs.impl"})
public abstract class AbstractCommitChangesAction
extends AbstractCommonCheckinAction {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext dataContext) {
        void $receiver$iv$iv;
        Project project = dataContext.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Object $receiver$iv = ProjectLevelVcsManager.getInstance((Project)project).getAllVersionedRoots();
        VirtualFile[] virtualFileArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((VirtualFile[])$receiver$iv).length);
        void var5_5 = $receiver$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)it);
            collection.add(filePath);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        FilePath[] filePathArray = thisCollection$iv.toArray(new FilePath[0]);
        if (filePathArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return filePathArray;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        Project project = dataContext.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        return ProjectLevelVcsManager.getInstance((Project)project).hasAnyMappings();
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        super.update(vcsContext, presentation);
        if (presentation.isEnabledAndVisible()) {
            Change[] changeArray;
            ChangeList[] changeListArray;
            Change[] changes2 = vcsContext.getSelectedChanges();
            if (Intrinsics.areEqual((Object)vcsContext.getPlace(), (Object)"ChangesViewPopup")) {
                boolean bl;
                ChangeList[] changeListArray2;
                ChangeList[] changeLists;
                changeListArray = changeLists = vcsContext.getSelectedChangeLists();
                Presentation presentation2 = presentation;
                boolean bl2 = changeListArray == null || (changeListArray2 = changeListArray).length == 0;
                Presentation presentation3 = presentation2;
                if (bl2) {
                    changeListArray = changes2;
                    presentation2 = presentation3;
                    bl2 = changeListArray == null || (changeListArray2 = changeListArray).length == 0;
                    presentation3 = presentation2;
                    bl = !bl2;
                } else {
                    bl = changeLists.length == 1 && !changeLists[0].getChanges().isEmpty();
                }
                presentation3.setEnabled(bl);
            }
            if (presentation.isEnabled() && !((changeArray = changes2) == null || (changeListArray = changeArray).length == 0)) {
                Project project = vcsContext.getProject();
                if (project == null) {
                    Intrinsics.throwNpe();
                }
                this.disableIfAnyHijackedChanges(project, presentation, changes2);
            }
        }
    }

    private final void disableIfAnyHijackedChanges(Project project, Presentation presentation, Change[] changes2) {
        boolean bl;
        block1: {
            Change[] $receiver$iv;
            ChangeListManager manager = ChangeListManager.getInstance((Project)project);
            Change[] changeArray = $receiver$iv = changes2;
            int n = changeArray.length;
            for (int i = 0; i < n; ++i) {
                Change element$iv;
                Change it = element$iv = changeArray[i];
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getFileStatus(), (Object)FileStatus.HIJACKED) && manager.getChangeList(it) == null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean hasHijackedChanges = bl;
        presentation.setEnabled(!hasHijackedChanges);
    }
}

