/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.NewChangelistDialog;
import org.jetbrains.annotations.NotNull;

public class AddChangeListAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        NewChangelistDialog dlg = new NewChangelistDialog(project);
        dlg.show();
        if (dlg.getExitCode() == 0) {
            String name = dlg.getName();
            if (name.length() == 0) {
                name = AddChangeListAction.getUniqueName(project);
            }
            LocalChangeList list2 = ChangeListManager.getInstance((Project)project).addChangeList(name, dlg.getDescription());
            if (dlg.isNewChangelistActive()) {
                ChangeListManager.getInstance((Project)project).setDefaultChangeList(list2);
            }
            dlg.getPanel().changelistCreatedOrChanged(list2);
        }
    }

    private static String getUniqueName(Project project) {
        int unnamedcount = 0;
        for (ChangeList list2 : ChangeListManagerImpl.getInstanceImpl(project).getChangeListsCopy()) {
            if (!list2.getName().startsWith("Unnamed")) continue;
            ++unnamedcount;
        }
        return unnamedcount == 0 ? "Unnamed" : "Unnamed (" + unnamedcount + ")";
    }

    public void update(@NotNull AnActionEvent e) {
        if (e.getPlace().equals("ChangesViewPopup")) {
            ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
            e.getPresentation().setVisible(lists != null && lists.length > 0);
        }
    }
}

