/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesVisibilityPredicate;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class BrowseChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.notNull((Object)ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project));
        CommittedChangesProvider provider = (CommittedChangesProvider)ObjectUtils.notNull((Object)vcs.getCommittedChangesProvider());
        ChangeBrowserSettings settings = BrowseChangesAction.getChangeBrowserSettings(project, vcs, provider);
        CommittedChangesFilterDialog dialog2 = new CommittedChangesFilterDialog(project, provider.createFilterUI(true), settings);
        if (dialog2.showAndGet()) {
            BrowseChangesAction.showChanges(vcs, file2, settings);
        }
    }

    private static ChangeBrowserSettings getChangeBrowserSettings(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull CommittedChangesProvider provider) {
        return vcs.getConfiguration().changeBrowserSettings.computeIfAbsent(vcs.getName(), key -> {
            ChangeBrowserSettings result2 = provider.createDefaultSettings();
            ServiceKt.getStateStore((ComponentManager)project).initPersistencePlainComponent(result2, "VcsManager.ChangeBrowser." + key);
            return result2;
        });
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Presentation presentation = e.getPresentation();
        if (project == null || file2 == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project);
        if (vcs == null || !CommittedChangesVisibilityPredicate.isCommittedChangesAvailable(vcs)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(BrowseChangesAction.isEnabled(project, vcs, file2));
    }

    private static boolean isEnabled(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile file2) {
        return vcs.allowsRemoteCalls(file2) && AbstractVcs.fileInVcsByFileStatus((Project)project, (VirtualFile)file2);
    }

    private static void showChanges(@NotNull AbstractVcs vcs, @NotNull VirtualFile file2, @NotNull ChangeBrowserSettings settings) {
        int maxCount;
        int n = maxCount = !settings.isAnyFilterSpecified() ? BrowseChangesAction.askMaxCount(vcs.getProject()) : 0;
        if (maxCount >= 0) {
            AbstractVcsHelper.getInstance((Project)vcs.getProject()).openCommittedChangesTab(vcs, file2, settings, maxCount, null);
        }
    }

    private static int askMaxCount(@NotNull Project project) {
        switch (Messages.showYesNoCancelDialog((Project)project, (String)VcsBundle.message((String)"browse.changes.no.filter.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.recent.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.all.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
            case 2: {
                return -1;
            }
            case 0: {
                return 50;
            }
        }
        return 0;
    }
}

