/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveChangesToAnotherListAction
extends AnAction
implements DumbAware {
    public MoveChangesToAnotherListAction() {
        super(ActionsBundle.actionText((String)"ChangesView.Move"), ActionsBundle.actionDescription((String)"ChangesView.Move"), null);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isEnabled = this.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return false;
        }
        return !UtilKt.isEmpty((Stream)((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY))) || !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES))) || !ArrayUtil.isEmpty((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
    }

    @NotNull
    private static List<Change> getChangesForSelectedFiles(@NotNull Project project, @NotNull VirtualFile[] selectedFiles, @NotNull List<? super VirtualFile> unversionedFiles, @NotNull List<? super VirtualFile> changedFiles) {
        ArrayList<Change> changes2 = new ArrayList<Change>();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        for (VirtualFile vFile : selectedFiles) {
            Change change = changeListManager.getChange(vFile);
            if (change == null) {
                FileStatus status = changeListManager.getStatus(vFile);
                if (FileStatus.UNKNOWN.equals(status)) {
                    unversionedFiles.add((VirtualFile)vFile);
                    changedFiles.add((VirtualFile)vFile);
                    continue;
                }
                if (!FileStatus.NOT_CHANGED.equals(status) || !vFile.isDirectory()) continue;
                MoveChangesToAnotherListAction.addAllChangesUnderPath(changeListManager, VcsUtil.getFilePath((VirtualFile)vFile), changes2, changedFiles);
                continue;
            }
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            if (afterPath != null && afterPath.isDirectory()) {
                MoveChangesToAnotherListAction.addAllChangesUnderPath(changeListManager, afterPath, changes2, changedFiles);
                continue;
            }
            changes2.add(change);
            changedFiles.add((VirtualFile)vFile);
        }
        return changes2;
    }

    private static void addAllChangesUnderPath(@NotNull ChangeListManager changeListManager, @NotNull FilePath file2, @NotNull List<? super Change> changes2, @NotNull List<? super VirtualFile> changedFiles) {
        for (Change change : changeListManager.getChangesIn(file2)) {
            changes2.add((Change)change);
            FilePath path = ChangesUtil.getAfterPath((Change)change);
            if (path == null || path.getVirtualFile() == null) continue;
            changedFiles.add((VirtualFile)path.getVirtualFile());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList changesList = ContainerUtil.newArrayList();
        Object[] changes2 = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes2 != null) {
            ContainerUtil.addAll((Collection)changesList, (Object[])changes2);
        }
        ArrayList unversionedFiles = ContainerUtil.newArrayList();
        ArrayList changedFiles = ContainerUtil.newArrayList();
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && changesList.isEmpty()) {
            changesList.addAll(MoveChangesToAnotherListAction.getChangesForSelectedFiles(project, files2, unversionedFiles, changedFiles));
        }
        if (changesList.isEmpty() && unversionedFiles.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Nothing is selected that can be moved", MessageType.INFO, new NamedRunnable[0]);
            return;
        }
        if (!MoveChangesToAnotherListAction.askAndMove(project, changesList, unversionedFiles)) {
            return;
        }
        if (!changedFiles.isEmpty()) {
            MoveChangesToAnotherListAction.selectAndShowFile(project, (VirtualFile)changedFiles.get(0));
        }
    }

    private static void selectAndShowFile(@NotNull Project project, @NotNull VirtualFile file2) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        if (!window.isVisible()) {
            window.activate(() -> ChangesViewManager.getInstance(project).selectFile(file2));
        }
    }

    public static boolean askAndMove(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @NotNull List<? extends VirtualFile> unversionedFiles) {
        if (changes2.isEmpty() && unversionedFiles.isEmpty()) {
            return false;
        }
        LocalChangeList targetList = MoveChangesToAnotherListAction.askTargetList(project, changes2);
        if (targetList != null) {
            ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project);
            listManager.moveChangesTo(targetList, changes2.toArray(new Change[0]));
            if (!unversionedFiles.isEmpty()) {
                listManager.addUnversionedFiles(targetList, unversionedFiles);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static LocalChangeList askTargetList(@NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<LocalChangeList> nonAffectedLists = MoveChangesToAnotherListAction.getNonAffectedLists(listManager.getChangeListsCopy(), changes2);
        List<LocalChangeList> suggestedLists = nonAffectedLists.isEmpty() ? Collections.singletonList(listManager.getDefaultChangeList()) : nonAffectedLists;
        ChangeList defaultSelection2 = MoveChangesToAnotherListAction.guessPreferredList(nonAffectedLists);
        ChangeListChooser chooser = new ChangeListChooser(project, suggestedLists, defaultSelection2, ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]), null);
        chooser.show();
        return chooser.getSelectedList();
    }

    @Nullable
    public static ChangeList guessPreferredList(@NotNull List<? extends LocalChangeList> lists) {
        LocalChangeList activeChangeList = (LocalChangeList)ContainerUtil.find(lists, LocalChangeList::isDefault);
        if (activeChangeList != null) {
            return activeChangeList;
        }
        LocalChangeList emptyList = (LocalChangeList)ContainerUtil.find(lists, list2 -> list2.getChanges().isEmpty());
        return (ChangeList)ObjectUtils.chooseNotNull((Object)emptyList, (Object)ContainerUtil.getFirstItem(lists));
    }

    @NotNull
    private static List<LocalChangeList> getNonAffectedLists(@NotNull List<? extends LocalChangeList> lists, @NotNull Collection<? extends Change> changes2) {
        HashSet changesSet = ContainerUtil.newHashSet(changes2);
        return ContainerUtil.findAll(lists, list2 -> !ContainerUtil.intersects((Collection)changesSet, (Collection)list2.getChanges()));
    }
}

