/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.RemoveChangeListAction$WhenMappings;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0002J,\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RemoveChangeListAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "askNewDefaultChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "project", "Lcom/intellij/openapi/project/Project;", "lists", "", "remainingLists", "canRemoveChangeLists", "", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "confirmAllChangeListsRemoval", "pendingLists", "toAsk", "confirmChangeListRemoval", "deleteLists", "", "update", "intellij.platform.vcs.impl"})
public final class RemoveChangeListAction
extends AnAction
implements DumbAware {
    private final Logger LOG;

    public void update(@NotNull AnActionEvent e) {
        Object[] changeListsArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        Object object = changeListsArray;
        if (changeListsArray == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object changeLists = object;
        boolean hasChanges = !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        boolean enabled = this.canRemoveChangeLists(e.getProject(), (List<? extends ChangeList>)changeLists);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enabled);
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"ChangesViewPopup")) {
            presentation.setVisible(enabled);
        }
        presentation.setText(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.text.template", (Object[])new Object[]{changeLists.size()}));
        if (hasChanges) {
            boolean bl;
            block7: {
                Iterable $receiver$iv = (Iterable)changeLists;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ChangeList it = (ChangeList)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof LocalChangeList && ((LocalChangeList)it).isDefault())) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean containsActiveChangelist = bl;
            presentation.setDescription(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.description.template", (Object[])new Object[]{changeLists.size(), containsActiveChangelist ? "another" : "default"}));
        } else {
            presentation.setDescription((String)null);
        }
    }

    private final boolean canRemoveChangeLists(Project project, List<? extends ChangeList> lists) {
        if (project == null || lists.isEmpty()) {
            return false;
        }
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            if (!((LocalChangeList)changeList).isReadOnly()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangeList[] selectedLists = (ChangeList[])e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        List<ChangeList> list2 = Arrays.asList(Arrays.copyOf(selectedLists, selectedLists.length));
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.openapi.vcs.changes.LocalChangeList>");
        }
        this.deleteLists(project, (Collection<? extends LocalChangeList>)list2);
    }

    private final void deleteLists(Project project, Collection<? extends LocalChangeList> lists) {
        boolean activeChangelistSelected;
        LocalChangeList it;
        List pendingLists;
        Iterable $receiver$iv;
        List toAsk;
        List toRemove2;
        ChangeListManagerEx manager;
        block22: {
            boolean bl;
            Iterator $receiver$iv$iv;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            if (changeListManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangeListManagerEx");
            }
            manager = (ChangeListManagerEx)changeListManager;
            toRemove2 = new ArrayList();
            toAsk = new ArrayList();
            $receiver$iv = lists;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LocalChangeList localChangeList;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                LocalChangeList it2 = (LocalChangeList)element$iv$iv;
                boolean bl2 = false;
                if (manager.getChangeList(it2.getId()) == null) continue;
                LocalChangeList it$iv$iv = localChangeList;
                destination$iv$iv.add(it$iv$iv);
            }
            for (LocalChangeList list2 : (List)destination$iv$iv) {
                switch (RemoveChangeListAction$WhenMappings.$EnumSwitchMapping$0[ChangeListRemoveConfirmation.INSTANCE.checkCanDeleteChangelist(project, list2, true).ordinal()]) {
                    case 1: {
                        toAsk.add(list2);
                        break;
                    }
                    case 2: {
                        toRemove2.add(list2);
                    }
                }
            }
            pendingLists = CollectionsKt.plus((Collection)toAsk, (Iterable)toRemove2);
            $receiver$iv = pendingLists;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (LocalChangeList)element$iv;
                    boolean bl3 = false;
                    if (!it.isDefault()) continue;
                    bl = true;
                    break block22;
                }
                bl = activeChangelistSelected = false;
            }
        }
        if (activeChangelistSelected) {
            List remainingLists = CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)manager.getChangeLists(), (Iterable)pendingLists));
            if (remainingLists.isEmpty()) {
                if (!this.confirmAllChangeListsRemoval(project, pendingLists, toAsk)) {
                    return;
                }
                LocalChangeList defaultList = manager.getChangeList(LocalChangeList.DEFAULT_NAME);
                if (defaultList == null) {
                    defaultList = manager.addChangeList(LocalChangeList.DEFAULT_NAME, null);
                } else {
                    manager.editComment(defaultList.getName(), null);
                    manager.editChangeListData(defaultList.getName(), null);
                }
                LocalChangeList localChangeList = defaultList;
                if (localChangeList == null) {
                    Intrinsics.throwNpe();
                }
                manager.setDefaultChangeList(localChangeList);
                toRemove2.addAll(toAsk);
                toRemove2.remove(defaultList);
            } else {
                LocalChangeList localChangeList = this.askNewDefaultChangeList(project, toAsk, remainingLists);
                if (localChangeList == null) {
                    return;
                }
                LocalChangeList newDefault = localChangeList;
                manager.setDefaultChangeList(newDefault);
                toRemove2.addAll(toAsk);
                if (toRemove2.remove(newDefault)) {
                    this.LOG.error("New default changelist should be selected among remaining");
                }
            }
        } else if (this.confirmChangeListRemoval(project, toAsk)) {
            toRemove2.addAll(toAsk);
        }
        $receiver$iv = toRemove2;
        for (Object element$iv : $receiver$iv) {
            it = (LocalChangeList)element$iv;
            boolean bl = false;
            manager.removeChangeList(it.getName());
        }
    }

    private final boolean confirmChangeListRemoval(Project project, List<? extends LocalChangeList> lists) {
        boolean haveNoChanges;
        block4: {
            boolean bl;
            Iterable $receiver$iv = lists;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl2 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block4;
                }
                bl = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        String message = lists.size() == 1 ? VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{((LocalChangeList)CollectionsKt.single(lists)).getName()}) : VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.size()});
        return Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private final boolean confirmAllChangeListsRemoval(Project project, List<? extends LocalChangeList> pendingLists, List<? extends LocalChangeList> toAsk) {
        boolean haveNoChanges;
        block6: {
            boolean bl;
            if (pendingLists.size() == 1) {
                return true;
            }
            if (toAsk.isEmpty()) {
                return true;
            }
            Iterable $receiver$iv = pendingLists;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl2 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block6;
                }
                bl = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        String message = VcsBundle.message((String)"changes.removechangelist.all.lists.warning.text", (Object[])new Object[]{pendingLists.size()});
        return Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final LocalChangeList askNewDefaultChangeList(Project project, List<? extends LocalChangeList> lists, List<? extends LocalChangeList> remainingLists) {
        void $receiver$iv$iv;
        boolean haveNoChanges;
        Object element$iv2;
        block8: {
            boolean bl;
            boolean bl2;
            Collection collection = remainingLists;
            boolean bl3 = bl2 = !collection.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = lists;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $receiver$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv2;
                    boolean bl4 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block8;
                }
                bl = haveNoChanges = true;
            }
        }
        if (remainingLists.size() == 1 && haveNoChanges) {
            return (LocalChangeList)CollectionsKt.single(remainingLists);
        }
        Iterable $receiver$iv = remainingLists;
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] remainingListsNames = objectArray;
        String message = haveNoChanges ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0]);
        int nameIndex = Messages.showChooseDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])remainingListsNames, (String)((String)ArraysKt.first((Object[])remainingListsNames)));
        if (nameIndex < 0) {
            return null;
        }
        return remainingLists.get(nameIndex);
    }

    public RemoveChangeListAction() {
        Logger logger;
        RemoveChangeListAction removeChangeListAction = this;
        boolean $i$f$logger = false;
        removeChangeListAction.LOG = logger = Logger.getInstance(RemoveChangeListAction.class);
    }
}

