/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RevertCommittedStuffAbstractAction
extends AnAction
implements DumbAware {
    private final boolean myReverse;

    protected RevertCommittedStuffAbstractAction(boolean reverse) {
        this.myReverse = reverse;
    }

    @Nullable
    protected abstract Change[] getChanges(@NotNull AnActionEvent var1, boolean var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        String action;
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        Change[] changes2 = this.getChanges(e, false);
        if (changes2 == null || changes2.length == 0) {
            return;
        }
        final ArrayList changesList = new ArrayList();
        Collections.addAll(changesList, changes2);
        FileDocumentManager.getInstance().saveAllDocuments();
        String defaultName = null;
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        String string = action = this.myReverse ? "Revert" : "Apply";
        if (changeLists != null && changeLists.length > 0) {
            defaultName = String.format("%s: %s", action, changeLists[0].getName());
        }
        final String title = String.format("%s Changes", action);
        final String errorPrefix = String.format("Failed to %s changes: ", StringUtil.toLowerCase((String)action));
        final ChangeListChooser chooser = new ChangeListChooser(project, ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, "Select Target Changelist", defaultName);
        if (!chooser.showAndGet()) {
            return;
        }
        final ArrayList patches2 = new ArrayList();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    List<Change> preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(changesList);
                    patches2.addAll(IdeaTextPatchBuilder.buildPatch(project, preprocessed, baseDir.getPresentableUrl(), RevertCommittedStuffAbstractAction.this.myReverse));
                }
                catch (VcsException ex) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project, (String)(errorPrefix + ex.getMessage()), (String)title), null, (Project)this.myProject);
                    indicator.cancel();
                }
            }

            public void onSuccess() {
                new PatchApplier(project, baseDir, patches2, chooser.getSelectedList(), null).execute();
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes2 = this.getChanges(e, true);
        return project != null && changes2 != null && changes2.length > 0;
    }
}

