/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace()) || "ChangesViewPopup".equals(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
        if (e.isFromActionToolbar() && e.getPresentation().getIcon() == null) {
            e.getPresentation().setIcon(IconUtil.getAddIcon());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List unversionedFiles = ScheduleForAdditionAction.getUnversionedFiles(e, project).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project, unversionedFiles, (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return e.getProject() != null && !UtilKt.isEmpty(ScheduleForAdditionAction.getUnversionedFiles(e, e.getProject()));
    }

    public static boolean addUnversioned(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @Nullable ChangesBrowserBase browser2) {
        return ScheduleForAdditionAction.addUnversioned(project, files2, browser2, null);
    }

    protected static boolean addUnversioned(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @Nullable ChangesBrowserBase browser2, @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
        if (files2.isEmpty() && additionalTask == null) {
            return true;
        }
        LocalChangeList targetChangeList = browser2 instanceof CommitDialogChangesBrowser ? ((CommitDialogChangesBrowser)browser2).getSelectedChangeList() : ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        Consumer changeConsumer = browser2 != null ? changes2 -> browser2.getViewer().includeChanges((Collection<?>)changes2) : null;
        FileDocumentManager.getInstance().saveAllDocuments();
        return ScheduleForAdditionAction.addUnversionedFilesToVcs(project, targetChangeList, files2, (Consumer<? super List<Change>>)changeConsumer, additionalTask);
    }

    @NotNull
    protected static Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project) {
        boolean hasExplicitUnversioned;
        boolean bl = hasExplicitUnversioned = !UtilKt.isEmpty((Stream)((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY)));
        if (hasExplicitUnversioned) {
            return (Stream)e.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        }
        if (!ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)))) {
            return Stream.empty();
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        return UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))).filter(file2 -> ScheduleForAdditionAction.isFileUnversioned(file2, vcsManager, changeListManager));
    }

    private static boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull ChangeListManager changeListManager) {
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || changeListManager.getStatus(file2) == FileStatus.UNKNOWN;
    }

    public static boolean addUnversionedFilesToVcs(@NotNull Project project, @NotNull LocalChangeList list2, @NotNull List<? extends VirtualFile> files2) {
        return ScheduleForAdditionAction.addUnversionedFilesToVcs(project, list2, files2, null, null);
    }

    protected static boolean addUnversionedFilesToVcs(final @NotNull Project project, @NotNull LocalChangeList list2, final @NotNull List<? extends VirtualFile> files2, @Nullable Consumer<? super List<Change>> changesConsumer, final @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
        boolean syncUpdateRequired;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        final ArrayList exceptions = new ArrayList();
        final HashSet allProcessedFiles = new HashSet();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Adding Files to VCS...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)files2, (vcs, files2) -> ScheduleForAdditionAction.addUnversionedFilesToVcs(project, vcs, (List<? extends VirtualFile>)files2, allProcessedFiles, exceptions));
                if (additionalTask != null) {
                    additionalTask.consume((Object)indicator, (Object)exceptions);
                }
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)project, (String)message.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file2 : allProcessedFiles) {
            fileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)project).filesDirty(allProcessedFiles, null);
        boolean moveRequired = !list2.isDefault() && !allProcessedFiles.isEmpty();
        boolean bl = syncUpdateRequired = changesConsumer != null;
        if (moveRequired || syncUpdateRequired) {
            InvokeAfterUpdateMode updateMode = syncUpdateRequired ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
            changeListManager.invokeAfterUpdate(() -> {
                List newChanges = ContainerUtil.filter((Collection)changeListManager.getDefaultChangeList().getChanges(), change -> {
                    FilePath path = ChangesUtil.getAfterPath((Change)change);
                    return path != null && allProcessedFiles.contains(path.getVirtualFile());
                });
                if (moveRequired && !newChanges.isEmpty()) {
                    changeListManager.moveChangesTo(list2, newChanges.toArray(new Change[0]));
                }
                ChangesViewManager.getInstance(project).scheduleRefresh();
                if (changesConsumer != null) {
                    changesConsumer.consume((Object)newChanges);
                }
            }, updateMode, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
        } else {
            ChangesViewManager.getInstance(project).scheduleRefresh();
        }
        return exceptions.isEmpty();
    }

    private static void addUnversionedFilesToVcs(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull List<? extends VirtualFile> items, @NotNull Set<? super VirtualFile> allProcessedFiles, @NotNull List<? super VcsException> exceptions) {
        CheckinEnvironment environment = vcs.getCheckinEnvironment();
        if (environment == null) {
            return;
        }
        Set descendants = (Set)ReadAction.compute(() -> ScheduleForAdditionAction.getUnversionedDescendantsRecursively(project, items));
        Set parents = (Set)ReadAction.compute(() -> ScheduleForAdditionAction.getUnversionedParents(project, vcs, items));
        List exs = environment.scheduleUnversionedFilesForAddition((List)ContainerUtil.newArrayList((Iterable)descendants));
        if (exs != null) {
            exceptions.addAll(exs);
        }
        allProcessedFiles.addAll(descendants);
        allProcessedFiles.addAll(parents);
    }

    @NotNull
    private static Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull Project project, @NotNull List<? extends VirtualFile> items) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        HashSet result2 = ContainerUtil.newHashSet();
        Processor addToResultProcessor = file2 -> {
            if (changeListManager.getStatus(file2) == FileStatus.UNKNOWN) {
                result2.add(file2);
            }
            return true;
        };
        for (VirtualFile virtualFile : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(project, virtualFile, (Processor<? super VirtualFile>)addToResultProcessor);
        }
        return result2;
    }

    @NotNull
    private static Set<VirtualFile> getUnversionedParents(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull Collection<? extends VirtualFile> items) {
        if (!vcs.areDirectoriesVersionedItems()) {
            return Collections.emptySet();
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        HashSet result2 = ContainerUtil.newHashSet();
        for (VirtualFile virtualFile : items) {
            for (VirtualFile parent = virtualFile.getParent(); parent != null && changeListManager.getStatus(parent) == FileStatus.UNKNOWN; parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        return result2;
    }
}

