/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeGoToChangePopupAction<Chain extends DiffRequestChain>
extends GoToChangePopupBuilder.BaseGoToChangePopupAction<Chain> {
    @Nullable
    private final Object myDefaultSelection;

    public ChangeGoToChangePopupAction(@NotNull Chain chain, @Nullable Object defaultSelection2) {
        super(chain);
        this.myDefaultSelection = defaultSelection2;
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel(@NotNull Project var1, @NotNull ChangesGroupingPolicyFactory var2);

    protected abstract void onSelected(@Nullable Object var1);

    @Override
    @NotNull
    protected JBPopup createPopup(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Ref popup2 = new Ref();
        MyChangesBrowser cb = new MyChangesBrowser(project, (Ref<? extends JBPopup>)popup2);
        popup2.set((Object)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)cb, cb.getPreferredFocusedComponent()).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setDimensionServiceKey(project, "Diff.GoToChangePopup", false).createPopup());
        return (JBPopup)popup2.get();
    }

    private class MyChangesBrowser
    extends ChangesBrowserBase {
        @NotNull
        private final Ref<? extends JBPopup> myRef;

        MyChangesBrowser(@NotNull Project project, Ref<? extends JBPopup> popupRef) {
            super(project, false, false);
            this.myRef = popupRef;
            this.myViewer.setSelectionMode(1);
            this.init();
            this.myViewer.rebuildTree();
            UiNotifyConnector.doWhenFirstShown((JComponent)this, () -> {
                if (ChangeGoToChangePopupAction.this.myDefaultSelection != null) {
                    this.selectEntries(Collections.singletonList(ChangeGoToChangePopupAction.this.myDefaultSelection));
                }
            });
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel() {
            return ChangeGoToChangePopupAction.this.buildTreeModel(this.myProject, this.getGrouping());
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            return Collections.emptyList();
        }

        @Override
        protected void onDoubleClick() {
            ((JBPopup)this.myRef.get()).cancel();
            Object selection = ContainerUtil.getFirstItem(VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> ChangeGoToChangePopupAction.this.onSelected(selection));
        }
    }
}

