/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffAction
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Change[] changes2 = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if ("MainMenu".equals(e.getPlace())) {
            e.getPresentation().setEnabled(project != null && changes2 != null && changes2.length > 0);
        } else {
            e.getPresentation().setEnabled(project != null && ShowDiffAction.canShowDiff(project, changes2));
        }
    }

    public static boolean canShowDiff(@Nullable Project project, @Nullable Change[] changes2) {
        return changes2 != null && ShowDiffAction.canShowDiff(project, Arrays.asList(changes2));
    }

    public static boolean canShowDiff(@Nullable Project project, @Nullable List<? extends Change> changes2) {
        if (changes2 == null || changes2.size() == 0) {
            return false;
        }
        for (Change change : changes2) {
            if (!ChangeDiffRequestProducer.canCreate(project, change)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Object[] changes2 = (Change[])e.getRequiredData(VcsDataKeys.CHANGES);
        ArrayList result2 = ContainerUtil.newArrayList((Object[])changes2);
        ShowDiffAction.showDiffForChange(project, result2, 0);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<? extends Change> changes2) {
        ShowDiffAction.showDiffForChange(project, changes2, 0);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<? extends Change> changes2, int index) {
        ShowDiffAction.showDiffForChange(project, changes2, index, new ShowDiffContext());
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull ListSelection<? extends Change> changes2) {
        ShowDiffAction.showDiffForChange(project, changes2, new ShowDiffContext());
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<? extends Change> changes2, @NotNull Condition<? super Change> condition, @NotNull ShowDiffContext context) {
        ArrayList list2 = ContainerUtil.newArrayList(changes2);
        int index = ContainerUtil.indexOf((List)list2, condition);
        ShowDiffAction.showDiffForChange(project, (ListSelection<? extends Change>)ListSelection.createAt((List)list2, (int)index), context);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<? extends Change> changes2, int index, @NotNull ShowDiffContext context) {
        ArrayList list2 = ContainerUtil.newArrayList(changes2);
        ShowDiffAction.showDiffForChange(project, (ListSelection<? extends Change>)ListSelection.createAt((List)list2, (int)index), context);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull ListSelection<? extends Change> changes2, @NotNull ShowDiffContext context) {
        ListSelection presentables = changes2.map(change -> ChangeDiffRequestProducer.create(project, change, context.getChangeContext((Change)change)));
        if (presentables.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(presentables.getList(), presentables.getSelectedIndex());
        for (Map.Entry<Key, Object> entry : context.getChainContext().entrySet()) {
            chain.putUserData(entry.getKey(), entry.getValue());
        }
        chain.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, context.getActions());
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, context.getDialogHints());
    }
}

