/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffContext {
    @NotNull
    private final DiffDialogHints myDialogHints;
    @Nullable
    private List<AnAction> myActions;
    @Nullable
    private Map<Key, Object> myChainContext;
    @Nullable
    private Map<Change, Map<Key, Object>> myRequestContext;

    public ShowDiffContext() {
        this(DiffDialogHints.DEFAULT);
    }

    public ShowDiffContext(@NotNull DiffDialogHints dialogHints) {
        this.myDialogHints = dialogHints;
    }

    @NotNull
    public DiffDialogHints getDialogHints() {
        return this.myDialogHints;
    }

    @NotNull
    public List<AnAction> getActions() {
        if (this.myActions == null) {
            return Collections.emptyList();
        }
        return this.myActions;
    }

    @NotNull
    public Map<Key, Object> getChainContext() {
        return ContainerUtil.notNullize(this.myChainContext);
    }

    @NotNull
    public Map<Key, Object> getChangeContext(@NotNull Change change) {
        if (this.myRequestContext == null) {
            return Collections.emptyMap();
        }
        Map<Key, Object> map2 = this.myRequestContext.get(change);
        if (map2 == null) {
            return Collections.emptyMap();
        }
        return map2;
    }

    public void addActions(@NotNull List<? extends AnAction> action) {
        if (this.myActions == null) {
            this.myActions = ContainerUtil.newArrayList();
        }
        this.myActions.addAll(action);
    }

    public void addAction(@NotNull AnAction action) {
        if (this.myActions == null) {
            this.myActions = ContainerUtil.newArrayList();
        }
        this.myActions.add(action);
    }

    public <T> void putChainContext(@NotNull Key<T> key, T value) {
        if (this.myChainContext == null) {
            this.myChainContext = ContainerUtil.newHashMap();
        }
        this.myChainContext.put(key, value);
    }

    public <T> void putChangeContext(@NotNull Change change, @NotNull Key<T> key, T value) {
        if (this.myRequestContext == null) {
            this.myRequestContext = ContainerUtil.newHashMap();
        }
        if (!this.myRequestContext.containsKey(change)) {
            this.myRequestContext.put(change, ContainerUtil.newHashMap());
        }
        this.myRequestContext.get(change).put(key, value);
    }
}

