/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffFromLocalChangesActionProvider
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(ChangesListView.DATA_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        Stream<Change> changes2 = view.getSelectedChanges();
        Stream<VirtualFile> unversionedFiles = view.getSelectedUnversionedFiles();
        if ("MainMenu".equals(e.getPlace())) {
            e.getPresentation().setEnabled(project != null && (changes2.findAny().isPresent() || unversionedFiles.findAny().isPresent()));
        } else {
            e.getPresentation().setEnabled(project != null && ShowDiffFromLocalChangesActionProvider.canShowDiff(project, changes2, unversionedFiles));
        }
    }

    private static boolean canShowDiff(@Nullable Project project, @NotNull Stream<Change> changes2, @NotNull Stream<VirtualFile> files2) {
        return files2.findAny().isPresent() || changes2.anyMatch(it -> ChangeDiffRequestProducer.canCreate(project, it));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List<Change> changes2 = view.getSelectedChanges().collect(Collectors.toList());
        List<VirtualFile> unversioned = view.getSelectedUnversionedFiles().collect(Collectors.toList());
        boolean needsConversion = ShowDiffFromLocalChangesActionProvider.checkIfThereAreFakeRevisions(project, changes2);
        if (needsConversion) {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(() -> {
                ((ChangesViewManager)ChangesViewManager.getInstance(project)).refreshImmediately();
                List<Change> actualChanges = ShowDiffFromLocalChangesActionProvider.loadFakeRevisions(project, changes2);
                ShowDiffFromLocalChangesActionProvider.showDiff(project, actualChanges, unversioned, view);
            }, InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, ActionsBundle.actionText((String)"Diff.ShowDiff"), ModalityState.current());
        } else {
            ShowDiffFromLocalChangesActionProvider.showDiff(project, changes2, unversioned, view);
        }
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project, @NotNull List<Change> changes2) {
        boolean needsConversion = false;
        for (Change change : changes2) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @NotNull
    private static List<Change> loadFakeRevisions(@NotNull Project project, @NotNull List<Change> changes2) {
        ArrayList<Change> actualChanges = new ArrayList<Change>();
        for (Change change : changes2) {
            actualChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        return actualChanges;
    }

    private static void showDiff(@NotNull Project project, @NotNull List<Change> changes2, @NotNull List<VirtualFile> unversioned, @NotNull ChangesListView changesView) {
        Change selectedChange;
        List<Change> changelistChanges;
        if (changes2.size() == 1 && unversioned.isEmpty() && (changelistChanges = changesView.getAllChangesFromSameChangelist(selectedChange = changes2.get(0))) != null) {
            int selectedIndex = ContainerUtil.indexOf(changelistChanges, it -> ChangeListChange.HASHING_STRATEGY.equals((Object)selectedChange, it));
            if (selectedIndex != -1) {
                ShowDiffFromLocalChangesActionProvider.showChangesDiff(project, (ListSelection<Change>)ListSelection.createAt(changelistChanges, (int)selectedIndex));
            } else {
                ShowDiffFromLocalChangesActionProvider.showChangesDiff(project, (ListSelection<Change>)ListSelection.create(changelistChanges, (Object)selectedChange));
            }
            return;
        }
        if (unversioned.size() == 1 && changes2.isEmpty()) {
            VirtualFile selectedFile = unversioned.get(0);
            List allUnversioned = changesView.getUnversionedFiles().collect(Collectors.toList());
            ShowDiffFromLocalChangesActionProvider.showUnversionedDiff(project, (ListSelection<VirtualFile>)ListSelection.create(allUnversioned, (Object)selectedFile));
            return;
        }
        ShowDiffFromLocalChangesActionProvider.showSelectionDiff(project, changes2, unversioned);
    }

    private static void showChangesDiff(@Nullable Project project, @NotNull ListSelection<Change> selection) {
        ListSelection producers = selection.map(change -> ChangeDiffRequestProducer.create(project, change));
        ShowDiffFromLocalChangesActionProvider.showDiff(project, producers.getList(), producers.getSelectedIndex());
    }

    private static void showUnversionedDiff(@Nullable Project project, @NotNull ListSelection<VirtualFile> selection) {
        ListSelection producers = selection.map(change -> UnversionedDiffRequestProducer.create(project, change));
        ShowDiffFromLocalChangesActionProvider.showDiff(project, producers.getList(), producers.getSelectedIndex());
    }

    private static void showSelectionDiff(@Nullable Project project, @NotNull List<Change> changes2, @NotNull List<VirtualFile> unversioned) {
        List changeRequests = ContainerUtil.mapNotNull(changes2, change -> ChangeDiffRequestProducer.create(project, change));
        List unversionedRequests = ContainerUtil.mapNotNull(unversioned, file2 -> UnversionedDiffRequestProducer.create(project, file2));
        ShowDiffFromLocalChangesActionProvider.showDiff(project, ContainerUtil.concat((List)changeRequests, (List)unversionedRequests), 0);
    }

    private static void showDiff(@Nullable Project project, @NotNull List<ChangeDiffRequestChain.Producer> producers, int selected) {
        if (producers.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(producers, selected);
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }
}

