/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListDiffRequest
extends ContentDiffRequest {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final String myChangelistId;
    @NotNull
    private final String myChangelistName;
    @NotNull
    private final ContentDiffRequest myRequest;
    private int myAssignments;
    private boolean myInstalled;

    public LocalChangeListDiffRequest(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String changelistId, @NotNull String changelistName, @NotNull ContentDiffRequest request) {
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myChangelistId = changelistId;
        this.myChangelistName = changelistName;
        this.myRequest = request;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public String getChangelistId() {
        return this.myChangelistId;
    }

    @NotNull
    public String getChangelistName() {
        return this.myChangelistName;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        return this.myRequest;
    }

    @Nullable
    public LineStatusTracker getLineStatusTracker() {
        return LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myVirtualFile);
    }

    @Nullable
    public String getTitle() {
        return String.format("%s [%s]", this.myRequest.getTitle(), this.myChangelistName);
    }

    @NotNull
    public List<DiffContent> getContents() {
        return this.myRequest.getContents();
    }

    @NotNull
    public List<String> getContentTitles() {
        List titles = this.myRequest.getContentTitles();
        String title1 = (String)titles.get(0);
        String title2 = (String)titles.get(1);
        String ourTitle2 = title2 != null ? String.format("%s in %s", title2, this.myChangelistName) : null;
        return ContainerUtil.list((Object[])new String[]{title1, ourTitle2});
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myRequest.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myRequest.putUserData(key, value);
    }

    public void onAssigned(boolean isAssigned) {
        this.myRequest.onAssigned(isAssigned);
        if (isAssigned) {
            if (!this.myInstalled) {
                this.myInstalled = this.installTracker();
            }
            ++this.myAssignments;
        } else {
            if (this.myAssignments == 1 && this.myInstalled) {
                this.releaseTracker();
                this.myInstalled = false;
            }
            --this.myAssignments;
        }
        assert (this.myAssignments >= 0);
    }

    private boolean installTracker() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        if (document == null) {
            return false;
        }
        LineStatusTrackerManager.getInstance(this.myProject).requestTrackerFor(document, (Object)this);
        return true;
    }

    private void releaseTracker() {
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        if (document == null) {
            return;
        }
        LineStatusTrackerManager.getInstance(this.myProject).releaseTrackerFor(document, (Object)this);
    }
}

