/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.MoveChangesLineStatusAction;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.ui.InplaceButton;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    @NotNull
    private final String myChangelistId;
    @NotNull
    private final String myChangelistName;
    private ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;
    private final boolean myAllowExcludeChangesFromCommit;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        super(context, (DiffRequest)localRequest.getRequest());
        this.myLocalRequest = localRequest;
        this.myChangelistId = localRequest.getChangelistId();
        this.myChangelistName = localRequest.getChangelistName();
        MyTrackerListener trackerListener = new MyTrackerListener();
        MyLineStatusTrackerManagerListener lstmListener = new MyLineStatusTrackerManagerListener(trackerListener);
        LineStatusTrackerManager.getInstanceImpl(this.getProject()).addTrackerListener(lstmListener, (Disposable)this);
        PartialLocalLineStatusTracker tracker = this.getPartialTracker();
        if (tracker != null) {
            tracker.addListener(trackerListener, (Disposable)this);
        }
        DiffUtil.registerAction((AnAction)new MoveSelectedChangesToAnotherChangelistAction(true), this.myPanel);
        DiffUtil.registerAction((AnAction)new ExcludeSelectedChangesFromCommitAction(true), this.myPanel);
        DiffUtil.registerAction((AnAction)new IncludeOnlySelectedChangesIntoCommitAction(true), this.myPanel);
        this.myAllowExcludeChangesFromCommit = Boolean.TRUE.equals(context.getUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT));
    }

    @Override
    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    @Nullable
    public PartialLocalLineStatusTracker getPartialTracker() {
        return (PartialLocalLineStatusTracker)ObjectUtils.tryCast((Object)this.myLocalRequest.getLineStatusTracker(), PartialLocalLineStatusTracker.class);
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, this.getEditors());
        assert (titles.size() == 2);
        this.myExcludeAllCheckboxPanel = new ExcludeAllCheckboxPanel();
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel((Component)titles.get(1)).addToLeft((Component)this.myExcludeAllCheckboxPanel);
        return DiffUtil.createSyncHeightComponents(ContainerUtil.list((Object[])new JComponent[]{titles.get(0), titleWithCheckbox}));
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.add((AnAction)new MoveSelectedChangesToAnotherChangelistAction(false));
        group.add((AnAction)new ExcludeSelectedChangesFromCommitAction(false));
        group.add((AnAction)new IncludeOnlySelectedChangesIntoCommitAction(false));
        return group;
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        LineStatusTracker tracker = this.myLocalRequest.getLineStatusTracker();
        if (tracker instanceof SimpleLocalLineStatusTracker) {
            return super.performRediff(indicator);
        }
        PartialLocalLineStatusTracker partialTracker = (PartialLocalLineStatusTracker)ObjectUtils.tryCast((Object)tracker, PartialLocalLineStatusTracker.class);
        if (partialTracker == null || this.getContent2().getDocument() != tracker.getDocument()) {
            return this.applyNotification(DiffNotifications.createError());
        }
        try {
            indicator.checkCanceled();
            TrackerData data = (TrackerData)ReadAction.compute(() -> {
                boolean isReleased = partialTracker.isReleased();
                boolean isOperational = partialTracker.isOperational();
                List<String> affectedChangelistIds = partialTracker.getAffectedChangeListsIds();
                if (!isOperational) {
                    return new TrackerData(isReleased, affectedChangelistIds, null);
                }
                List<LocalRange> ranges = partialTracker.getRanges();
                CharSequence localText = this.getContent2().getDocument().getImmutableCharSequence();
                CharSequence vcsText = this.getContent1().getDocument().getImmutableCharSequence();
                CharSequence trackerVcsText = partialTracker.getVcsDocument().getImmutableCharSequence();
                TrackerDiffData diffData = new TrackerDiffData(ranges, localText, vcsText, trackerVcsText);
                return new TrackerData(isReleased, affectedChangelistIds, diffData);
            });
            if (data.isReleased) {
                return this.applyNotification(DiffNotifications.createError());
            }
            TrackerDiffData diffData = data.diffData;
            if (diffData == null || diffData.ranges == null) {
                if (data.affectedChangelist.size() == 1 && data.affectedChangelist.contains(this.myChangelistId)) {
                    Runnable callback2 = super.performRediff(indicator);
                    return () -> {
                        callback2.run();
                        this.getStatusPanel().setBusy(true);
                    };
                }
                this.scheduleRediff();
                throw new ProcessCanceledException();
            }
            return this.performRediffUsingPartialTracker(diffData.ranges, diffData.localText, diffData.vcsText, diffData.trackerVcsText, indicator);
        }
        catch (DiffTooBigException e) {
            return this.applyNotification(DiffNotifications.createDiffTooBig());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return this.applyNotification(DiffNotifications.createError());
        }
    }

    @NotNull
    private Runnable performRediffUsingPartialTracker(@NotNull List<LocalRange> ranges, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText, @NotNull ProgressIndicator indicator) {
        if (!StringUtil.equals((CharSequence)trackerVcsText, (CharSequence)vcsText)) {
            return this.applyNotification(DiffNotifications.createError());
        }
        if (this.myTextDiffProvider.isHighlightingDisabled()) {
            return this.apply(new SimpleDiffViewer.CompareData(null, ranges.isEmpty()));
        }
        List linesRanges = ContainerUtil.map(ranges, range2 -> new Range(range2.getVcsLine1(), range2.getVcsLine2(), range2.getLine1(), range2.getLine2()));
        List newFragments = (List)ObjectUtils.notNull(this.myTextDiffProvider.compare(vcsText, localText, linesRanges, indicator));
        boolean isContentsEqual = ranges.isEmpty();
        ArrayList<SimpleDiffChange> changes2 = new ArrayList<SimpleDiffChange>();
        for (int i = 0; i < ranges.size(); ++i) {
            LocalRange localRange = ranges.get(i);
            List rangeFragments = (List)newFragments.get(i);
            boolean isExcludedFromCommit = localRange.isExcludedFromCommit();
            boolean isFromActiveChangelist = localRange.getChangelistId().equals(this.myChangelistId);
            boolean isSkipped = !isFromActiveChangelist;
            boolean isExcluded = !isFromActiveChangelist || this.myAllowExcludeChangesFromCommit && isExcludedFromCommit;
            changes2.addAll(ContainerUtil.map((Collection)rangeFragments, fragment -> new MySimpleDiffChange((LineFragment)fragment, isExcluded, isSkipped, localRange.getChangelistId(), isExcludedFromCommit)));
        }
        return this.apply(new SimpleDiffViewer.CompareData(changes2, isContentsEqual));
    }

    @Override
    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    @NotNull
    private static BitSet getLocalSelectedLines(@NotNull List<MySimpleDiffChange> changes2) {
        BitSet selectedLines = new BitSet();
        for (SimpleDiffChange simpleDiffChange : changes2) {
            int endLine;
            int startLine;
            selectedLines.set(startLine, (startLine = simpleDiffChange.getStartLine(Side.RIGHT)) == (endLine = simpleDiffChange.getEndLine(Side.RIGHT)) ? startLine + 1 : endLine);
        }
        return selectedLines;
    }

    private static class TrackerDiffData {
        @Nullable
        public final List<LocalRange> ranges;
        @NotNull
        public final CharSequence localText;
        @NotNull
        public final CharSequence vcsText;
        @NotNull
        public final CharSequence trackerVcsText;

        TrackerDiffData(@Nullable List<LocalRange> ranges, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText) {
            this.ranges = ranges;
            this.localText = localText;
            this.vcsText = vcsText;
            this.trackerVcsText = trackerVcsText;
        }
    }

    private static class TrackerData {
        private final boolean isReleased;
        @NotNull
        public final List<String> affectedChangelist;
        @Nullable
        public final TrackerDiffData diffData;

        TrackerData(boolean isReleased, @NotNull List<String> affectedChangelist, @Nullable TrackerDiffData diffData) {
            this.isReleased = isReleased;
            this.affectedChangelist = affectedChangelist;
            this.diffData = diffData;
        }
    }

    private class ExcludeAllCheckboxPanel
    extends JPanel {
        private final InplaceButton myCheckbox = new InplaceButton(null, AllIcons.Diff.GutterCheckBox, e -> this.toggleState());

        private ExcludeAllCheckboxPanel() {
            this.myCheckbox.setCursor(Cursor.getPredefinedCursor(12));
            this.myCheckbox.setVisible(false);
            this.add((Component)this.myCheckbox);
            SimpleLocalChangeListDiffViewer.this.getEditor2().getGutterComponentEx().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> ExcludeAllCheckboxPanel.this.updateLayout(), ModalityState.any());
                }
            });
        }

        @Override
        public void doLayout() {
            Dimension size = this.myCheckbox.getPreferredSize();
            EditorGutterComponentEx gutter = SimpleLocalChangeListDiffViewer.this.getEditor2().getGutterComponentEx();
            int y = (this.getHeight() - size.height) / 2;
            int x = gutter.getIconAreaOffset() + 2;
            this.myCheckbox.setBounds(Math.min(this.getWidth() - AllIcons.Diff.GutterCheckBox.getIconWidth(), x), Math.max(0, y), size.width, size.height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = this.myCheckbox.getPreferredSize();
            EditorGutterComponentEx gutter = SimpleLocalChangeListDiffViewer.this.getEditor2().getGutterComponentEx();
            int gutterWidth = gutter.getLineMarkerFreePaintersAreaOffset();
            return new Dimension(Math.max(gutterWidth + JBUI.scale((int)2), size.width), size.height);
        }

        private void updateLayout() {
            this.invalidate();
            SimpleLocalChangeListDiffViewer.this.myPanel.validate();
            SimpleLocalChangeListDiffViewer.this.myPanel.repaint();
        }

        private void toggleState() {
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            if (tracker != null && tracker.isValid()) {
                ExclusionState exclusionState = tracker.getExcludedFromCommitState(SimpleLocalChangeListDiffViewer.this.myChangelistId);
                SimpleLocalChangeListDiffViewer.this.getPartialTracker().setExcludedFromCommit(exclusionState == ExclusionState.ALL_INCLUDED);
                this.refresh();
                SimpleLocalChangeListDiffViewer.this.rediff();
            }
        }

        public void refresh() {
            Icon icon = this.getIcon();
            if (icon != null) {
                this.myCheckbox.setIcon(icon);
                this.myCheckbox.setVisible(true);
            } else {
                this.myCheckbox.setVisible(false);
            }
        }

        @Nullable
        private Icon getIcon() {
            if (!SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                return null;
            }
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            if (tracker == null || !tracker.isValid()) {
                return null;
            }
            ExclusionState exclusionState = tracker.getExcludedFromCommitState(SimpleLocalChangeListDiffViewer.this.myChangelistId);
            switch (exclusionState) {
                case ALL_INCLUDED: {
                    return AllIcons.Diff.GutterCheckBoxSelected;
                }
                case ALL_EXCLUDED: {
                    return AllIcons.Diff.GutterCheckBox;
                }
                case PARTIALLY: {
                    return AllIcons.Diff.GutterCheckBoxIndeterminate;
                }
            }
            return null;
        }
    }

    private abstract class MySelectedChangesActionBase
    extends DumbAwareAction {
        private final boolean myActiveChangelistOnly;
        private final boolean myShortcut;

        MySelectedChangesActionBase(boolean activeChangelistOnly, boolean shortcut) {
            this.myActiveChangelistOnly = activeChangelistOnly;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (this.myActiveChangelistOnly && !SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || tracker == null) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                e.getPresentation().setText(this.getText(Collections.emptyList()));
                return;
            }
            List<MySimpleDiffChange> selectedChanges = this.getSelectedChanges(side);
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(!selectedChanges.isEmpty());
            e.getPresentation().setText(this.getText(selectedChanges));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (editor == null || side == null || tracker == null) {
                return;
            }
            List<MySimpleDiffChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, tracker, selectedChanges);
        }

        @NotNull
        private List<MySimpleDiffChange> getSelectedChanges(@NotNull Side side) {
            List changes2 = ContainerUtil.findAll((Collection)SimpleLocalChangeListDiffViewer.this.getSelectedChanges(side), MySimpleDiffChange.class);
            if (this.myActiveChangelistOnly) {
                return ContainerUtil.filter((Collection)changes2, MySimpleDiffChange::isFromActiveChangelist);
            }
            return changes2;
        }

        @NotNull
        protected String getText(@NotNull List<MySimpleDiffChange> selectedChanges) {
            return this.getTemplatePresentation().getText();
        }

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull PartialLocalLineStatusTracker var2, @NotNull List<MySimpleDiffChange> var3);
    }

    private class IncludeOnlySelectedChangesIntoCommitAction
    extends MySelectedChangesActionBase {
        IncludeOnlySelectedChangesIntoCommitAction(boolean shortcut) {
            super(true, shortcut);
            ActionUtil.copyFrom((AnAction)this, (String)"Vcs.Diff.IncludeOnlyChangedLinesIntoCommit");
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<MySimpleDiffChange> selectedChanges) {
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            tracker.setExcludedFromCommit(true);
            tracker.setExcludedFromCommit(selectedLines, false);
            SimpleLocalChangeListDiffViewer.this.rediff();
        }
    }

    private class ExcludeSelectedChangesFromCommitAction
    extends MySelectedChangesActionBase {
        ExcludeSelectedChangesFromCommitAction(boolean shortcut) {
            super(true, shortcut);
            ActionUtil.copyFrom((AnAction)this, (String)"Vcs.Diff.ExcludeChangedLinesFromCommit");
        }

        @Override
        @NotNull
        protected String getText(@NotNull List<MySimpleDiffChange> selectedChanges) {
            boolean hasExcluded = ContainerUtil.or(selectedChanges, MySimpleDiffChange::isExcludedFromCommit);
            return selectedChanges.isEmpty() || !hasExcluded ? "Exclude Lines from Commit" : "Include Lines into Commit";
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<MySimpleDiffChange> selectedChanges) {
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            boolean hasExcluded = ContainerUtil.or(selectedChanges, MySimpleDiffChange::isExcludedFromCommit);
            tracker.setExcludedFromCommit(selectedLines, !hasExcluded);
            SimpleLocalChangeListDiffViewer.this.rediff();
        }
    }

    private class MoveSelectedChangesToAnotherChangelistAction
    extends MySelectedChangesActionBase {
        MoveSelectedChangesToAnotherChangelistAction(boolean shortcut) {
            super(false, shortcut);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.MoveChangedLinesToChangelist"));
        }

        @Override
        @NotNull
        protected String getText(@NotNull List<MySimpleDiffChange> selectedChanges) {
            if (!selectedChanges.isEmpty() && ContainerUtil.and(selectedChanges, change -> !change.isFromActiveChangelist())) {
                String shortChangeListName = StringUtil.trimMiddle((String)SimpleLocalChangeListDiffViewer.this.myChangelistName, (int)40);
                return String.format("Move to '%s' Changelist", StringUtil.escapeMnemonics((String)shortChangeListName));
            }
            return ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]);
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<MySimpleDiffChange> selectedChanges) {
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            if (ContainerUtil.and(selectedChanges, change -> !change.isFromActiveChangelist())) {
                LocalChangeList changeList = ChangeListManager.getInstance((Project)SimpleLocalChangeListDiffViewer.this.getProject()).getChangeList(SimpleLocalChangeListDiffViewer.this.myChangelistId);
                if (changeList != null) {
                    tracker.moveToChangelist(selectedLines, changeList);
                }
            } else {
                MoveChangesLineStatusAction.moveToAnotherChangelist(tracker, selectedLines);
            }
            SimpleLocalChangeListDiffViewer.this.rediff();
        }
    }

    private class MyLineStatusTrackerManagerListener
    extends LineStatusTrackerManager.ListenerAdapter {
        @NotNull
        private final PartialLocalLineStatusTracker.Listener myListener;

        MyLineStatusTrackerManagerListener(PartialLocalLineStatusTracker.Listener trackerListener) {
            this.myListener = trackerListener;
        }

        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            if (tracker instanceof PartialLocalLineStatusTracker && tracker.getVirtualFile().equals(SimpleLocalChangeListDiffViewer.this.myLocalRequest.getVirtualFile())) {
                ((PartialLocalLineStatusTracker)tracker).addListener(this.myListener, (Disposable)SimpleLocalChangeListDiffViewer.this);
                SimpleLocalChangeListDiffViewer.this.scheduleRediff();
            }
        }
    }

    private class MyTrackerListener
    extends PartialLocalLineStatusTracker.ListenerAdapter {
        private MyTrackerListener() {
        }

        @Override
        public void onBecomingValid(@NotNull PartialLocalLineStatusTracker tracker) {
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onChangeListMarkerChange(@NotNull PartialLocalLineStatusTracker tracker) {
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }
    }

    private class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsExcludedFromCommit;

        MySimpleDiffChange(LineFragment fragment, boolean isExcluded, @NotNull boolean isSkipped, String changelistId, boolean isExcludedFromCommit) {
            super(SimpleLocalChangeListDiffViewer.this, fragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        private SimpleLocalChangeListDiffViewer getViewer() {
            return (SimpleLocalChangeListDiffViewer)this.myViewer;
        }

        public boolean isFromActiveChangelist() {
            return this.myChangelistId.equals(this.getViewer().myChangelistId);
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }

        @Override
        protected void doInstallActionHighlighters() {
            super.doInstallActionHighlighters();
            if (SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit && this.isFromActiveChangelist()) {
                this.myOperations.add(new ExcludeGutterOperation());
            }
        }

        private class ExcludeGutterOperation
        extends SimpleDiffChange.GutterOperation {
            ExcludeGutterOperation() {
                super(Side.RIGHT);
            }

            @Override
            public GutterIconRenderer createRenderer() {
                if (!MySimpleDiffChange.this.isFromActiveChangelist()) {
                    return null;
                }
                Icon icon = MySimpleDiffChange.this.myIsExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
                return new DiffGutterRenderer(icon, "Include into commit"){

                    @Override
                    protected void handleMouseClick() {
                        if (!MySimpleDiffChange.this.isValid()) {
                            return;
                        }
                        PartialLocalLineStatusTracker tracker = MySimpleDiffChange.this.getViewer().getPartialTracker();
                        if (tracker == null) {
                            return;
                        }
                        LocalRange range2 = (LocalRange)tracker.getRangeForLine(MySimpleDiffChange.this.getStartLine(Side.RIGHT));
                        if (range2 == null) {
                            return;
                        }
                        tracker.setExcludedFromCommit(range2, !MySimpleDiffChange.this.myIsExcludedFromCommit);
                        MySimpleDiffChange.this.getViewer().rediff();
                    }
                };
            }
        }
    }
}

