/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToNewDiffUtil {
    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        ArrayList<DiffContent> newContents = new ArrayList<DiffContent>(contents.length);
        for (com.intellij.openapi.diff.DiffContent content : contents) {
            newContents.add(MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), content));
        }
        return new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, Arrays.asList(titles));
    }

    @NotNull
    private static DiffContent convertContent(@Nullable Project project, @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        DiffContentFactory factory = DiffContentFactory.getInstance();
        if (oldContent.isEmpty()) {
            return factory.createEmpty();
        }
        if (oldContent instanceof FileContent) {
            VirtualFile file2 = (VirtualFile)ObjectUtils.assertNotNull((Object)oldContent.getFile());
            return factory.create(project, file2);
        }
        if (oldContent instanceof SimpleContent) {
            return factory.create(project, ((SimpleContent)oldContent).getText(), oldContent.getContentType());
        }
        Document document = (Document)ObjectUtils.assertNotNull((Object)oldContent.getDocument());
        return factory.create(project, document, oldContent.getContentType());
    }

    @NotNull
    public static MergeRequest convertMergeRequest(@NotNull MergeRequestImpl request) throws InvalidDiffRequestException {
        MergeRequestImpl.MergeContent mergeContent = (MergeRequestImpl.MergeContent)((Object)ObjectUtils.assertNotNull((Object)((Object)request.getMergeContent())));
        MergeVersion.MergeDocumentVersion mergeVersion = (MergeVersion.MergeDocumentVersion)mergeContent.getMergeVersion();
        SimpleContent leftContent = (SimpleContent)request.getContents()[0];
        SimpleContent rightContent = (SimpleContent)request.getContents()[2];
        List contents = ContainerUtil.list((Object[])new String[]{leftContent.getText(), mergeVersion.getOriginalText(), rightContent.getText()});
        Document document = mergeContent.getDocument();
        String windowTitle = request.getWindowTitle();
        List<String> titles = Arrays.asList(request.getContentTitles());
        Consumer callback2 = result2 -> request.setResult(result2 == MergeResult.CANCEL ? 1 : 0);
        return DiffRequestFactory.getInstance().createMergeRequest(request.getProject(), mergeContent.getContentType(), document, contents, windowTitle, titles, callback2);
    }
}

