/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RootsCalculator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachesHolder {
    @NonNls
    private static final String VCS_CACHE_PATH = "vcsCache";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, ChangesCacheFile> myCacheFiles = ContainerUtil.newConcurrentMap();
    @NotNull
    private final RepositoryLocationCache myLocationCache;
    @NotNull
    private final ProjectLevelVcsManager myPlManager;

    public CachesHolder(@NotNull Project project, @NotNull RepositoryLocationCache locationCache) {
        this.myProject = project;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public Map<VirtualFile, RepositoryLocation> getAllRootsUnderVcs(@NotNull AbstractVcs vcs) {
        return new RootsCalculator(this.myProject, vcs, this.myLocationCache).getRoots();
    }

    public void iterateAllCaches(@NotNull Processor<? super ChangesCacheFile> processor2) {
        for (AbstractVcs vcs : this.myPlManager.getAllActiveVcss()) {
            if (!(vcs.getCommittedChangesProvider() instanceof CachingCommittedChangesProvider)) continue;
            for (Map.Entry<VirtualFile, RepositoryLocation> entry : this.getAllRootsUnderVcs(vcs).entrySet()) {
                ChangesCacheFile cacheFile = this.getCacheFile(vcs, entry.getKey(), entry.getValue());
                if (processor2.process((Object)cacheFile)) continue;
                return;
            }
        }
    }

    public void clearAllCaches() {
        this.myCacheFiles.values().forEach(ChangesCacheFile::delete);
        this.myCacheFiles.clear();
    }

    @NotNull
    public Collection<ChangesCacheFile> getAllCaches() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.iterateAllCaches((Processor<? super ChangesCacheFile>)processor2);
        return processor2.getResults();
    }

    @NotNull
    public ChangesCacheFile getCacheFile(@NotNull AbstractVcs vcs, @NotNull VirtualFile root, @NotNull RepositoryLocation location) {
        return this.myCacheFiles.computeIfAbsent(location.getKey(), key -> new ChangesCacheFile(this.myProject, this.getCachePath(location), vcs, root, location));
    }

    @NotNull
    public File getCacheBasePath() {
        File file2 = new File(PathManager.getSystemPath(), VCS_CACHE_PATH);
        file2 = new File(file2, this.myProject.getLocationHash());
        return file2;
    }

    @NotNull
    private File getCachePath(@NotNull RepositoryLocation location) {
        File file2 = this.getCacheBasePath();
        file2.mkdirs();
        return new File(file2, DigestUtils.md5Hex((String)location.getKey()));
    }

    @Nullable
    public ChangesCacheFile haveCache(@NotNull RepositoryLocation location) {
        String key = location.getKey();
        ChangesCacheFile result2 = this.myCacheFiles.get(key);
        if (result2 == null) {
            String keyWithSlash = key.endsWith("/") ? key : key + "/";
            String cachedSimilarKey = (String)ContainerUtil.find(this.myCacheFiles.keySet(), s -> keyWithSlash.startsWith((String)s) || s.startsWith(keyWithSlash));
            result2 = cachedSimilarKey != null ? this.myCacheFiles.get(cachedSimilarKey) : null;
        }
        return result2;
    }
}

