/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.google.common.base.Stopwatch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListByDateComparator;
import com.intellij.openapi.vcs.changes.committed.IncomingChangeState;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesCacheFile {
    private static final Logger LOG = Logger.getInstance(ChangesCacheFile.class);
    private static final int VERSION = 7;
    private final File myPath;
    private final File myIndexPath;
    private RandomAccessFile myStream;
    private RandomAccessFile myIndexStream;
    private boolean myStreamsOpen;
    private final Project myProject;
    private final AbstractVcs myVcs;
    private final CachingCommittedChangesProvider myChangesProvider;
    private final ProjectLevelVcsManager myVcsManager;
    private final FilePath myRootPath;
    private final RepositoryLocation myLocation;
    private Date myFirstCachedDate;
    private Date myLastCachedDate;
    private long myFirstCachedChangelist;
    private long myLastCachedChangelist;
    private int myIncomingCount;
    private boolean myHaveCompleteHistory;
    private boolean myHeaderLoaded;
    @NonNls
    private static final String INDEX_EXTENSION = ".index";
    private static final int INDEX_ENTRY_SIZE = 26;
    private static final int HEADER_SIZE = 46;
    private static final IndexEntry[] NO_ENTRIES = new IndexEntry[0];

    public ChangesCacheFile(Project project, File path, AbstractVcs vcs, VirtualFile root, RepositoryLocation location) {
        this.reset();
        this.myProject = project;
        this.myPath = path;
        this.myIndexPath = new File(this.myPath.toString() + INDEX_EXTENSION);
        this.myVcs = vcs;
        this.myChangesProvider = (CachingCommittedChangesProvider)vcs.getCommittedChangesProvider();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myRootPath = VcsUtil.getFilePath((VirtualFile)root);
        this.myLocation = location;
    }

    private void reset() {
        Calendar date = Calendar.getInstance();
        date.set(2020, 1, 2);
        this.myFirstCachedDate = date.getTime();
        date.set(1970, 1, 2);
        this.myLastCachedDate = date.getTime();
        this.myIncomingCount = 0;
        this.myLastCachedChangelist = -1L;
        this.myFirstCachedChangelist = Long.MAX_VALUE;
        this.myHaveCompleteHistory = false;
        this.myHeaderLoaded = false;
    }

    public RepositoryLocation getLocation() {
        return this.myLocation;
    }

    public CachingCommittedChangesProvider getProvider() {
        return this.myChangesProvider;
    }

    public boolean isEmpty() throws IOException {
        if (!this.myPath.exists()) {
            return true;
        }
        try {
            this.loadHeader();
        }
        catch (VersionMismatchException | EOFException ex) {
            this.myPath.delete();
            this.myIndexPath.delete();
            return true;
        }
        return false;
    }

    public void delete() {
        FileUtil.delete((File)this.myPath);
        FileUtil.delete((File)this.myIndexPath);
        try {
            this.closeStreams();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    public List<CommittedChangeList> writeChanges(List<? extends CommittedChangeList> changes2) throws IOException {
        Collections.sort(changes2, CommittedChangeListByDateComparator.ASCENDING);
        return this.writeChanges(changes2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommittedChangeList> writeChanges(List<? extends CommittedChangeList> changes2, @Nullable List<Boolean> present) throws IOException {
        assert (present == null || present.size() == changes2.size());
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>(changes2.size());
        boolean wasEmpty = this.isEmpty();
        this.openStreams();
        try {
            if (wasEmpty) {
                this.myHeaderLoaded = true;
                this.writeHeader();
            }
            this.myStream.seek(this.myStream.length());
            IndexEntry[] entries2 = this.readLastIndexEntries(0, changes2.size());
            Iterator<Boolean> iterator = present == null ? null : present.iterator();
            for (CommittedChangeList committedChangeList : changes2) {
                boolean duplicate = false;
                for (IndexEntry entry : entries2) {
                    if (committedChangeList.getCommitDate().getTime() != entry.date || committedChangeList.getNumber() != entry.number) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    ChangesCacheFile.debug("Skipping duplicate changelist " + committedChangeList.getNumber());
                    continue;
                }
                ChangesCacheFile.debug("Writing incoming changelist " + committedChangeList.getNumber());
                result2.add(committedChangeList);
                long position = this.myStream.getFilePointer();
                this.myChangesProvider.writeChangeList((DataOutput)this.myStream, committedChangeList);
                this.updateCachedRange(committedChangeList);
                this.writeIndexEntry(committedChangeList.getNumber(), committedChangeList.getCommitDate().getTime(), position, present == null ? false : iterator.next());
                ++this.myIncomingCount;
            }
            this.writeHeader();
            this.myHeaderLoaded = true;
        }
        finally {
            this.closeStreams();
        }
        return result2;
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private void updateCachedRange(CommittedChangeList list2) {
        if (list2.getCommitDate().getTime() > this.myLastCachedDate.getTime()) {
            this.myLastCachedDate = list2.getCommitDate();
        }
        if (list2.getCommitDate().getTime() < this.myFirstCachedDate.getTime()) {
            this.myFirstCachedDate = list2.getCommitDate();
        }
        if (list2.getNumber() < this.myFirstCachedChangelist) {
            this.myFirstCachedChangelist = list2.getNumber();
        }
        if (list2.getNumber() > this.myLastCachedChangelist) {
            this.myLastCachedChangelist = list2.getNumber();
        }
    }

    private void writeIndexEntry(long number, long date, long offset, boolean completelyDownloaded) throws IOException {
        this.myIndexStream.writeLong(number);
        this.myIndexStream.writeLong(date);
        this.myIndexStream.writeLong(offset);
        this.myIndexStream.writeShort(completelyDownloaded ? 1 : 0);
    }

    private void openStreams() throws FileNotFoundException {
        this.myStream = new RandomAccessFile(this.myPath, "rw");
        this.myIndexStream = new RandomAccessFile(this.myIndexPath, "rw");
        this.myStreamsOpen = true;
    }

    private void closeStreams() throws IOException {
        this.myStreamsOpen = false;
        try {
            if (this.myStream != null) {
                this.myStream.close();
            }
        }
        finally {
            if (this.myIndexStream != null) {
                this.myIndexStream.close();
            }
        }
    }

    private void writeHeader() throws IOException {
        assert (this.myStreamsOpen && this.myHeaderLoaded);
        this.myStream.seek(0L);
        this.myStream.writeInt(7);
        this.myStream.writeInt(this.myChangesProvider.getFormatVersion());
        this.myStream.writeLong(this.myLastCachedDate.getTime());
        this.myStream.writeLong(this.myFirstCachedDate.getTime());
        this.myStream.writeLong(this.myFirstCachedChangelist);
        this.myStream.writeLong(this.myLastCachedChangelist);
        this.myStream.writeShort(this.myHaveCompleteHistory ? 1 : 0);
        this.myStream.writeInt(this.myIncomingCount);
        ChangesCacheFile.debug("Saved header for cache of " + this.myLocation + ": last cached date=" + this.myLastCachedDate + ", last cached number=" + this.myLastCachedChangelist + ", incoming count=" + this.myIncomingCount);
    }

    private IndexEntry[] readIndexEntriesByOffset(long offsetFromStart, int count) throws IOException {
        if (!this.myIndexPath.exists()) {
            return NO_ENTRIES;
        }
        long totalCount = this.myIndexStream.length() / 26L;
        if ((long)count > totalCount - offsetFromStart) {
            count = (int)(totalCount - offsetFromStart);
        }
        if (count == 0) {
            return NO_ENTRIES;
        }
        this.myIndexStream.seek(26L * offsetFromStart);
        IndexEntry[] result2 = new IndexEntry[count];
        for (int i = count - 1; i >= 0; --i) {
            result2[i] = new IndexEntry();
            this.readIndexEntry(result2[i]);
        }
        return result2;
    }

    private IndexEntry[] readLastIndexEntries(int offset, int count) throws IOException {
        if (!this.myIndexPath.exists()) {
            return NO_ENTRIES;
        }
        long totalCount = this.myIndexStream.length() / 26L;
        if ((long)count > totalCount - (long)offset) {
            count = (int)totalCount - offset;
        }
        if (count == 0) {
            return NO_ENTRIES;
        }
        this.myIndexStream.seek(this.myIndexStream.length() - 26L * ((long)count + (long)offset));
        IndexEntry[] result2 = new IndexEntry[count];
        for (int i = 0; i < count; ++i) {
            result2[i] = new IndexEntry();
            this.readIndexEntry(result2[i]);
        }
        return result2;
    }

    private void readIndexEntry(IndexEntry result2) throws IOException {
        result2.number = this.myIndexStream.readLong();
        result2.date = this.myIndexStream.readLong();
        result2.offset = this.myIndexStream.readLong();
        result2.completelyDownloaded = this.myIndexStream.readShort() != 0;
    }

    public Date getLastCachedDate() throws IOException {
        this.loadHeader();
        return this.myLastCachedDate;
    }

    public Date getFirstCachedDate() throws IOException {
        this.loadHeader();
        return this.myFirstCachedDate;
    }

    public long getFirstCachedChangelist() throws IOException {
        this.loadHeader();
        return this.myFirstCachedChangelist;
    }

    public long getLastCachedChangelist() throws IOException {
        this.loadHeader();
        return this.myLastCachedChangelist;
    }

    private void loadHeader() throws IOException {
        if (!this.myHeaderLoaded) {
            try (RandomAccessFile stream = new RandomAccessFile(this.myPath, "r");){
                int version2 = stream.readInt();
                if (version2 != 7) {
                    throw new VersionMismatchException();
                }
                int providerVersion = stream.readInt();
                if (providerVersion != this.myChangesProvider.getFormatVersion()) {
                    throw new VersionMismatchException();
                }
                this.myLastCachedDate = new Date(stream.readLong());
                this.myFirstCachedDate = new Date(stream.readLong());
                this.myFirstCachedChangelist = stream.readLong();
                this.myLastCachedChangelist = stream.readLong();
                this.myHaveCompleteHistory = stream.readShort() != 0;
                this.myIncomingCount = stream.readInt();
                assert (stream.getFilePointer() == 46L);
            }
            this.myHeaderLoaded = true;
        }
    }

    public Iterator<ChangesBunch> getBackBunchedIterator(int bunchSize) {
        return new BackIterator(bunchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Boolean> loadAllData(List<? super CommittedChangeList> lists) throws IOException {
        ArrayList<Boolean> idx = new ArrayList<Boolean>();
        this.openStreams();
        try {
            this.loadHeader();
            long length = this.myIndexStream.length();
            long totalCount = length / 26L;
            int i = 0;
            while ((long)i < totalCount) {
                long indexOffset = length - ((long)i + 1L) * 26L;
                this.myIndexStream.seek(indexOffset);
                IndexEntry e = new IndexEntry();
                this.readIndexEntry(e);
                CommittedChangeList list2 = this.loadChangeListAt(e.offset);
                lists.add((CommittedChangeList)list2);
                idx.add(e.completelyDownloaded);
                ++i;
            }
        }
        finally {
            this.closeStreams();
        }
        return idx;
    }

    public void editChangelist(long number, String message) throws IOException {
        ArrayList lists = new ArrayList();
        List<Boolean> present = this.loadAllData(lists);
        for (CommittedChangeList list2 : lists) {
            if (list2.getNumber() != number) continue;
            list2.setDescription(message);
            break;
        }
        this.delete();
        Collections.reverse(lists);
        Collections.reverse(present);
        this.writeChanges(lists, present);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CommittedChangeList> readChangesInterval(long indexOffset, int number) throws IOException {
        this.openStreams();
        try {
            IndexEntry[] entries2 = this.readIndexEntriesByOffset(indexOffset, number);
            if (entries2.length == 0) {
                List<CommittedChangeList> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
            for (IndexEntry entry : entries2) {
                CommittedChangeList changeList = this.loadChangeListAt(entry.offset);
                result2.add(changeList);
            }
            ArrayList<CommittedChangeList> arrayList = result2;
            return arrayList;
        }
        finally {
            this.closeStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommittedChangeList> readChanges(ChangeBrowserSettings settings, int maxCount) throws IOException {
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        ChangeBrowserSettings.Filter filter = settings.createFilter();
        this.openStreams();
        try {
            if (maxCount == 0) {
                this.myStream.seek(46L);
                while (this.myStream.getFilePointer() < this.myStream.length()) {
                    CommittedChangeList changeList = this.myChangesProvider.readChangeList(this.myLocation, (DataInput)this.myStream);
                    if (!filter.accepts(changeList)) continue;
                    result2.add(changeList);
                }
            } else if (!settings.isAnyFilterSpecified()) {
                IndexEntry[] entries2;
                for (IndexEntry entry : entries2 = this.readLastIndexEntries(0, maxCount)) {
                    this.myStream.seek(entry.offset);
                    result2.add(this.myChangesProvider.readChangeList(this.myLocation, (DataInput)this.myStream));
                }
            } else {
                IndexEntry[] entries3;
                int offset = 0;
                while (result2.size() < maxCount && (entries3 = this.readLastIndexEntries(offset, 1)).length != 0) {
                    CommittedChangeList changeList = this.loadChangeListAt(entries3[0].offset);
                    if (filter.accepts(changeList)) {
                        result2.add(0, changeList);
                    }
                    ++offset;
                }
            }
            ArrayList<CommittedChangeList> arrayList = result2;
            return arrayList;
        }
        finally {
            this.closeStreams();
        }
    }

    public boolean hasCompleteHistory() {
        return this.myHaveCompleteHistory;
    }

    public void setHaveCompleteHistory(boolean haveCompleteHistory) {
        if (this.myHaveCompleteHistory != haveCompleteHistory) {
            this.myHaveCompleteHistory = haveCompleteHistory;
            try {
                this.openStreams();
                try {
                    this.writeHeader();
                }
                finally {
                    this.closeStreams();
                }
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommittedChangeList> loadIncomingChanges() throws IOException {
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        int offset = 0;
        this.openStreams();
        try {
            IndexEntry[] entries2;
            while ((entries2 = this.readLastIndexEntries(offset, 1)).length != 0) {
                if (!entries2[0].completelyDownloaded) {
                    IncomingChangeListData data = this.readIncomingChangeListData(offset, entries2[0]);
                    if (data.accountedChanges.size() == 0) {
                        result2.add(data.changeList);
                    } else {
                        ReceivedChangeList changeList = new ReceivedChangeList(data.changeList);
                        for (Change change : data.changeList.getChanges()) {
                            if (data.accountedChanges.contains(change)) continue;
                            changeList.addChange(change);
                        }
                        result2.add((CommittedChangeList)changeList);
                    }
                    if (result2.size() == this.myIncomingCount) break;
                }
                ++offset;
            }
            ChangesCacheFile.debug("Loaded " + result2.size() + " incoming changelists");
        }
        finally {
            this.closeStreams();
        }
        return result2;
    }

    private CommittedChangeList loadChangeListAt(long clOffset) throws IOException {
        this.myStream.seek(clOffset);
        return this.myChangesProvider.readChangeList(this.myLocation, (DataInput)this.myStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUpdatedFiles(UpdatedFiles updatedFiles, Collection<? super CommittedChangeList> receivedChanges) throws IOException {
        boolean haveUnaccountedUpdatedFiles = false;
        this.openStreams();
        this.loadHeader();
        ReceivedChangeListTracker tracker = new ReceivedChangeListTracker();
        try {
            List<IncomingChangeListData> incomingData = this.loadIncomingChangeListData();
            for (FileGroup group : updatedFiles.getTopLevelGroups()) {
                haveUnaccountedUpdatedFiles |= this.processGroup(group, incomingData, tracker);
            }
            if (!haveUnaccountedUpdatedFiles) {
                for (IncomingChangeListData data : incomingData) {
                    this.saveIncoming(data, false);
                }
                this.writeHeader();
            }
        }
        finally {
            this.closeStreams();
        }
        receivedChanges.addAll(tracker.getChangeLists());
        return haveUnaccountedUpdatedFiles;
    }

    private void saveIncoming(IncomingChangeListData data, boolean haveNoMoreIncoming) throws IOException {
        this.writePartial(data, haveNoMoreIncoming);
        if (data.accountedChanges.size() == data.changeList.getChanges().size() || haveNoMoreIncoming) {
            ChangesCacheFile.debug("Removing changelist " + data.changeList.getNumber() + " from incoming changelists");
            this.myIndexStream.seek(data.indexOffset);
            this.writeIndexEntry(data.indexEntry.number, data.indexEntry.date, data.indexEntry.offset, true);
            --this.myIncomingCount;
        }
    }

    private boolean processGroup(FileGroup group, List<? extends IncomingChangeListData> incomingData, ReceivedChangeListTracker tracker) {
        boolean haveUnaccountedUpdatedFiles = false;
        List list2 = group.getFilesAndRevisions(this.myVcsManager);
        for (Pair pair : list2) {
            String file2 = (String)pair.first;
            FilePath path = VcsUtil.getFilePath((String)file2, (boolean)false);
            if (!path.isUnder(this.myRootPath, false) || pair.second == null) continue;
            if (group.getId().equals("REMOVED_FROM_REPOSITORY")) {
                haveUnaccountedUpdatedFiles |= ChangesCacheFile.processDeletedFile(path, incomingData, tracker);
                continue;
            }
            haveUnaccountedUpdatedFiles |= ChangesCacheFile.processFile(path, (VcsRevisionNumber)pair.second, incomingData, tracker);
        }
        for (FileGroup childGroup : group.getChildren()) {
            haveUnaccountedUpdatedFiles |= this.processGroup(childGroup, incomingData, tracker);
        }
        return haveUnaccountedUpdatedFiles;
    }

    private static boolean processFile(FilePath path, VcsRevisionNumber number, List<? extends IncomingChangeListData> incomingData, ReceivedChangeListTracker tracker) {
        boolean foundRevision = false;
        ChangesCacheFile.debug("Processing updated file " + path + ", revision " + number);
        for (IncomingChangeListData incomingChangeListData : incomingData) {
            for (Change change : incomingChangeListData.changeList.getChanges()) {
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision == null || !afterRevision.getFile().equals(path)) continue;
                int rc = number.compareTo((Object)afterRevision.getRevisionNumber());
                if (rc == 0) {
                    foundRevision = true;
                }
                if (rc < 0) continue;
                tracker.addChange(incomingChangeListData.changeList, change);
                incomingChangeListData.accountedChanges.add(change);
            }
        }
        ChangesCacheFile.debug(foundRevision ? "All changes for file found" : "Some of changes for file not found");
        return !foundRevision;
    }

    private static boolean processDeletedFile(FilePath path, List<? extends IncomingChangeListData> incomingData, ReceivedChangeListTracker tracker) {
        boolean foundRevision = false;
        for (IncomingChangeListData incomingChangeListData : incomingData) {
            for (Change change : incomingChangeListData.changeList.getChanges()) {
                ContentRevision beforeRevision = change.getBeforeRevision();
                if (beforeRevision == null || !beforeRevision.getFile().equals(path)) continue;
                tracker.addChange(incomingChangeListData.changeList, change);
                incomingChangeListData.accountedChanges.add(change);
                if (change.getAfterRevision() != null) continue;
                foundRevision = true;
            }
        }
        return !foundRevision;
    }

    private List<IncomingChangeListData> loadIncomingChangeListData() throws IOException {
        long length = this.myIndexStream.length();
        long totalCount = length / 26L;
        ArrayList<IncomingChangeListData> incomingData = new ArrayList<IncomingChangeListData>();
        int i = 0;
        while ((long)i < totalCount) {
            long indexOffset = length - ((long)i + 1L) * 26L;
            this.myIndexStream.seek(indexOffset);
            IndexEntry e = new IndexEntry();
            this.readIndexEntry(e);
            if (!e.completelyDownloaded) {
                incomingData.add(this.readIncomingChangeListData(indexOffset, e));
                if (incomingData.size() == this.myIncomingCount) break;
            }
            ++i;
        }
        ChangesCacheFile.debug("Loaded " + incomingData.size() + " incoming changelist pointers");
        return incomingData;
    }

    private IncomingChangeListData readIncomingChangeListData(long indexOffset, IndexEntry e) throws IOException {
        IncomingChangeListData data = new IncomingChangeListData();
        data.indexOffset = indexOffset;
        data.indexEntry = e;
        data.changeList = this.loadChangeListAt(e.offset);
        this.readPartial(data);
        return data;
    }

    private void writePartial(IncomingChangeListData data, boolean haveNoMoreIncoming) throws IOException {
        File partialFile = this.getPartialPath(data.indexEntry.offset);
        int accounted = data.accountedChanges.size();
        if (haveNoMoreIncoming || accounted == data.changeList.getChanges().size()) {
            partialFile.delete();
        } else if (accounted > 0) {
            try (RandomAccessFile file2 = new RandomAccessFile(partialFile, "rw");){
                file2.writeInt(accounted);
                for (Change c : data.accountedChanges) {
                    boolean isAfterRevision = true;
                    ContentRevision revision = c.getAfterRevision();
                    if (revision == null) {
                        isAfterRevision = false;
                        revision = c.getBeforeRevision();
                        assert (revision != null);
                    }
                    file2.writeByte(isAfterRevision ? 1 : 0);
                    file2.writeUTF(revision.getFile().getIOFile().toString());
                }
            }
        }
    }

    private void readPartial(IncomingChangeListData data) {
        HashSet<Change> result2;
        block18: {
            result2 = new HashSet<Change>();
            try {
                File partialFile = this.getPartialPath(data.indexEntry.offset);
                if (!partialFile.exists()) break block18;
                try (RandomAccessFile file2 = new RandomAccessFile(partialFile, "r");){
                    int count = file2.readInt();
                    if (count > 0) {
                        Collection changes2 = data.changeList.getChanges();
                        HashMap<String, Change> beforePaths = new HashMap<String, Change>();
                        HashMap<String, Change> afterPaths = new HashMap<String, Change>();
                        for (Change change : changes2) {
                            if (change.getBeforeRevision() != null) {
                                beforePaths.put(FilePathsHelper.convertPath((FilePath)change.getBeforeRevision().getFile()), change);
                            }
                            if (change.getAfterRevision() == null) continue;
                            afterPaths.put(FilePathsHelper.convertPath((FilePath)change.getAfterRevision().getFile()), change);
                        }
                        for (int i = 0; i < count; ++i) {
                            boolean isAfterRevision = file2.readByte() != 0;
                            String path = file2.readUTF();
                            String converted = FilePathsHelper.convertPath((String)path);
                            Change change = isAfterRevision ? (Change)afterPaths.get(converted) : (Change)beforePaths.get(converted);
                            if (change == null) continue;
                            result2.add(change);
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
        data.accountedChanges = result2;
    }

    @NonNls
    private File getPartialPath(long offset) {
        return new File(this.myPath + "." + offset + ".partial");
    }

    public boolean refreshIncomingChanges() throws IOException, VcsException {
        if (this.myProject.isDisposed()) {
            return false;
        }
        DiffProvider diffProvider = this.myVcs.getDiffProvider();
        if (diffProvider == null) {
            return false;
        }
        return new RefreshIncomingChangesOperation(this, this.myProject, diffProvider).invoke();
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public FilePath getRootPath() {
        return this.myRootPath;
    }

    private static class ReceivedChangeListTracker {
        private final Map<CommittedChangeList, ReceivedChangeList> myMap = new HashMap<CommittedChangeList, ReceivedChangeList>();

        private ReceivedChangeListTracker() {
        }

        public void addChange(CommittedChangeList changeList, Change change) {
            ReceivedChangeList list2 = this.myMap.get(changeList);
            if (list2 == null) {
                list2 = new ReceivedChangeList(changeList);
                this.myMap.put(changeList, list2);
            }
            list2.addChange(change);
        }

        public Collection<? extends CommittedChangeList> getChangeLists() {
            return this.myMap.values();
        }
    }

    private static class VersionMismatchException
    extends RuntimeException {
        private VersionMismatchException() {
        }
    }

    private static class IncomingChangeListData {
        public long indexOffset;
        public IndexEntry indexEntry;
        public CommittedChangeList changeList;
        public Set<Change> accountedChanges;

        private IncomingChangeListData() {
        }

        List<Change> getChangesToProcess() {
            return ContainerUtil.filter((Collection)this.changeList.getChanges(), change -> !this.accountedChanges.contains(change));
        }
    }

    private static class IndexEntry {
        long number;
        long date;
        long offset;
        boolean completelyDownloaded;

        private IndexEntry() {
        }
    }

    private static class RefreshIncomingChangesOperation {
        private final Set<FilePath> myDeletedFiles = new HashSet<FilePath>();
        private final Set<FilePath> myCreatedFiles = new HashSet<FilePath>();
        private final Set<FilePath> myReplacedFiles = new HashSet<FilePath>();
        private final Map<Long, IndexEntry> myIndexEntryCache = new HashMap<Long, IndexEntry>();
        private final Map<Long, CommittedChangeList> myPreviousChangeListsCache = new HashMap<Long, CommittedChangeList>();
        private final ChangeListManagerImpl myClManager;
        private final ChangesCacheFile myChangesCacheFile;
        private final Project myProject;
        private final DiffProvider myDiffProvider;
        private boolean myAnyChanges;
        private long myIndexStreamCachedLength;

        RefreshIncomingChangesOperation(ChangesCacheFile changesCacheFile, Project project, DiffProvider diffProvider) {
            this.myChangesCacheFile = changesCacheFile;
            this.myProject = project;
            this.myDiffProvider = diffProvider;
            this.myClManager = ChangeListManagerImpl.getInstanceImpl(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() throws VcsException, IOException {
            this.myChangesCacheFile.myLocation.onBeforeBatch();
            Collection incomingFiles = this.myChangesCacheFile.myChangesProvider.getIncomingFiles(this.myChangesCacheFile.myLocation);
            this.myAnyChanges = false;
            this.myChangesCacheFile.openStreams();
            this.myChangesCacheFile.loadHeader();
            try {
                boolean shouldChangeHeader;
                IncomingChangeState.header(this.myChangesCacheFile.myLocation.toPresentableString());
                List list2 = this.myChangesCacheFile.loadIncomingChangeListData();
                if (incomingFiles != null && incomingFiles.isEmpty()) {
                    shouldChangeHeader = !list2.isEmpty();
                    for (IncomingChangeListData data : list2) {
                        this.myChangesCacheFile.saveIncoming(data, true);
                    }
                } else {
                    Stopwatch stopWatch = Stopwatch.createStarted();
                    shouldChangeHeader = this.refreshIncomingInFile(incomingFiles, list2);
                    ChangesCacheFile.debug("Finished incoming refresh for " + this.myChangesCacheFile.myLocation.toPresentableString() + " in " + stopWatch.stop());
                }
                IncomingChangeState.footer();
                if (shouldChangeHeader) {
                    this.myChangesCacheFile.writeHeader();
                }
            }
            finally {
                this.myChangesCacheFile.myLocation.onAfterBatch();
                this.myChangesCacheFile.closeStreams();
            }
            return this.myAnyChanges;
        }

        private boolean refreshIncomingInFile(Collection<FilePath> incomingFiles, List<? extends IncomingChangeListData> list2) throws IOException {
            HashMap revisionDependentFiles = ContainerUtil.newHashMap();
            HashMap results = ContainerUtil.newHashMap();
            this.myIndexStreamCachedLength = this.myChangesCacheFile.myIndexStream.length();
            Stopwatch stopWatch = Stopwatch.createUnstarted();
            for (IncomingChangeListData incomingChangeListData : list2) {
                stopWatch.reset().start();
                ChangesCacheFile.debug("Checking incoming changelist " + incomingChangeListData.changeList.getNumber());
                for (Change change : incomingChangeListData.getChangesToProcess()) {
                    ProcessingResult result2 = this.processIncomingChange(change, incomingChangeListData, incomingFiles);
                    Pair key = Pair.create((Object)incomingChangeListData, (Object)change);
                    results.put(key, result2);
                    if (result2.revisionDependentProcessing == null) continue;
                    revisionDependentFiles.put(key, result2.file);
                }
                ChangesCacheFile.debug("Finished checking incoming changelist " + incomingChangeListData.changeList.getNumber() + " in " + stopWatch.stop());
            }
            if (!revisionDependentFiles.isEmpty()) {
                HashSet uniqueFiles = ContainerUtil.newHashSet(revisionDependentFiles.values());
                Map map2 = this.myDiffProvider instanceof DiffProviderEx ? ((DiffProviderEx)this.myDiffProvider).getCurrentRevisions((Iterable)uniqueFiles) : DiffProviderEx.getCurrentRevisions((Iterable)uniqueFiles, (DiffProvider)this.myDiffProvider);
                for (IncomingChangeListData incomingChangeListData : list2) {
                    for (Change change : incomingChangeListData.getChangesToProcess()) {
                        Pair key = Pair.create((Object)incomingChangeListData, (Object)change);
                        Function<VcsRevisionNumber, ProcessingResult> revisionHandler = ((ProcessingResult)results.get((Object)key)).revisionDependentProcessing;
                        if (revisionHandler == null) continue;
                        results.put(key, revisionHandler.fun(map2.get(revisionDependentFiles.get(key))));
                    }
                }
            }
            for (IncomingChangeListData incomingChangeListData : list2) {
                boolean bl;
                boolean updated = false;
                boolean bl2 = false;
                for (Change change : incomingChangeListData.getChangesToProcess()) {
                    ContentRevision revision;
                    ContentRevision contentRevision = revision = change.getAfterRevision() == null ? change.getBeforeRevision() : change.getAfterRevision();
                    assert (revision != null);
                    ProcessingResult result3 = (ProcessingResult)results.get(Pair.create((Object)incomingChangeListData, (Object)change));
                    new IncomingChangeState(change, revision.getRevisionNumber().asString(), result3.state).logSelf();
                    if (result3.changeFound) {
                        updated = true;
                        incomingChangeListData.accountedChanges.add(change);
                        continue;
                    }
                    bl = true;
                }
                if (!updated && bl) continue;
                this.myAnyChanges = true;
                this.myChangesCacheFile.saveIncoming(incomingChangeListData, !bl);
            }
            return this.myAnyChanges || !list2.isEmpty();
        }

        private ProcessingResult processIncomingChange(Change change, IncomingChangeListData changeListData, @Nullable Collection<FilePath> incomingFiles) {
            CommittedChangeList changeList = changeListData.changeList;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision != null) {
                if (afterRevision.getFile().isNonLocal()) {
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_DOES_NOT_MATTER_NON_LOCAL);
                }
                if (change.getBeforeRevision() == null) {
                    FilePath path = afterRevision.getFile();
                    ChangesCacheFile.debug("Marking created file " + path);
                    this.myCreatedFiles.add(path);
                } else if (change.getBeforeRevision().getFile().getPath().equals(afterRevision.getFile().getPath()) && change.isIsReplaced()) {
                    this.myReplacedFiles.add(afterRevision.getFile());
                }
                if (incomingFiles != null && !incomingFiles.contains(afterRevision.getFile())) {
                    ChangesCacheFile.debug("Skipping new/changed file outside of incoming files: " + afterRevision.getFile());
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_DOES_NOT_MATTER_OUTSIDE_INCOMING);
                }
                ChangesCacheFile.debug("Checking file " + afterRevision.getFile().getPath());
                FilePath localPath = ChangesUtil.getLocalPath((Project)this.myProject, (FilePath)afterRevision.getFile());
                if (!FileUtil.isAncestor((File)this.myChangesCacheFile.myRootPath.getIOFile(), (File)localPath.getIOFile(), (boolean)false)) {
                    ChangesCacheFile.debug("Alien path " + localPath.getPresentableUrl() + " under root " + this.myChangesCacheFile.myRootPath.getPresentableUrl() + "; skipping.");
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_DOES_NOT_MATTER_ALIEN_PATH);
                }
                VirtualFile file2 = localPath.getVirtualFile();
                if (RefreshIncomingChangesOperation.isDeletedFile(this.myDeletedFiles, afterRevision, this.myReplacedFiles)) {
                    ChangesCacheFile.debug("Found deleted file");
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_DOES_NOT_MATTER_DELETED_FOUND_IN_INCOMING_LIST);
                }
                if (file2 != null) {
                    return new ProcessingResult(file2, revision -> {
                        if (revision != null) {
                            ChangesCacheFile.debug("Current revision is " + revision + ", changelist revision is " + afterRevision.getRevisionNumber());
                            if (this.myChangesCacheFile.myChangesProvider.isChangeLocallyAvailable(afterRevision.getFile(), revision, afterRevision.getRevisionNumber(), changeList)) {
                                return new ProcessingResult(true, IncomingChangeState.State.AFTER_EXISTS_LOCALLY_AVAILABLE);
                            }
                            return new ProcessingResult(false, IncomingChangeState.State.AFTER_EXISTS_NOT_LOCALLY_AVAILABLE);
                        }
                        ChangesCacheFile.debug("Failed to fetch revision");
                        return new ProcessingResult(false, IncomingChangeState.State.AFTER_EXISTS_REVISION_NOT_LOADED);
                    });
                }
                if (this.myChangesCacheFile.myChangesProvider.isChangeLocallyAvailable(afterRevision.getFile(), null, afterRevision.getRevisionNumber(), changeList)) {
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_NOT_EXISTS_LOCALLY_AVAILABLE);
                }
                if (this.fileMarkedForDeletion(localPath)) {
                    ChangesCacheFile.debug("File marked for deletion and not committed jet.");
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_NOT_EXISTS_MARKED_FOR_DELETION);
                }
                if (this.wasSubsequentlyDeleted(afterRevision.getFile(), changeListData.indexOffset)) {
                    return new ProcessingResult(true, IncomingChangeState.State.AFTER_NOT_EXISTS_SUBSEQUENTLY_DELETED);
                }
                ChangesCacheFile.debug("Could not find local file for change " + afterRevision.getFile().getPath());
                return new ProcessingResult(false, IncomingChangeState.State.AFTER_NOT_EXISTS_OTHER);
            }
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null);
            ChangesCacheFile.debug("Checking deleted file " + beforeRevision.getFile());
            this.myDeletedFiles.add(beforeRevision.getFile());
            if (incomingFiles != null && !incomingFiles.contains(beforeRevision.getFile())) {
                ChangesCacheFile.debug("Skipping deleted file outside of incoming files: " + beforeRevision.getFile());
                return new ProcessingResult(true, IncomingChangeState.State.BEFORE_DOES_NOT_MATTER_OUTSIDE);
            }
            if (beforeRevision.getFile().getVirtualFile() == null || this.myCreatedFiles.contains(beforeRevision.getFile())) {
                boolean locallyDeleted = this.myClManager.isContainedInLocallyDeleted(beforeRevision.getFile());
                ChangesCacheFile.debug(locallyDeleted ? "File deleted locally, change marked as incoming" : "File already deleted");
                return new ProcessingResult(!locallyDeleted, locallyDeleted ? IncomingChangeState.State.BEFORE_NOT_EXISTS_DELETED_LOCALLY : IncomingChangeState.State.BEFORE_NOT_EXISTS_ALREADY_DELETED);
            }
            if (!this.myChangesCacheFile.myVcs.fileExistsInVcs(beforeRevision.getFile())) {
                ChangesCacheFile.debug("File exists locally and is unversioned");
                return new ProcessingResult(true, IncomingChangeState.State.BEFORE_UNVERSIONED_INSTEAD_OF_VERS_DELETED);
            }
            VirtualFile file3 = beforeRevision.getFile().getVirtualFile();
            return new ProcessingResult(file3, currentRevision -> {
                if (currentRevision != null && currentRevision.compareTo((Object)beforeRevision.getRevisionNumber()) > 0) {
                    ChangesCacheFile.debug("File with same name was added after file deletion");
                    return new ProcessingResult(true, IncomingChangeState.State.BEFORE_SAME_NAME_ADDED_AFTER_DELETION);
                }
                ChangesCacheFile.debug("File exists locally and no 'create' change found for it");
                return new ProcessingResult(false, IncomingChangeState.State.BEFORE_EXISTS_BUT_SHOULD_NOT);
            });
        }

        private boolean fileMarkedForDeletion(FilePath localPath) {
            List changeLists = this.myClManager.getChangeListsCopy();
            for (LocalChangeList list2 : changeLists) {
                Collection changes2 = list2.getChanges();
                for (Change change : changes2) {
                    if (change.getBeforeRevision() == null || change.getBeforeRevision().getFile() == null || !change.getBeforeRevision().getFile().getPath().equals(localPath.getPath()) || !FileStatus.DELETED.equals(change.getFileStatus()) && !change.isMoved() && !change.isRenamed()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean wasSubsequentlyDeleted(FilePath file2, long indexOffset) {
            try {
                indexOffset += 26L;
                while (indexOffset < this.myIndexStreamCachedLength) {
                    IndexEntry e = this.getIndexEntryAtOffset(indexOffset);
                    CommittedChangeList changeList = this.getChangeListAtOffset(e.offset);
                    for (Change c : changeList.getChanges()) {
                        ContentRevision beforeRevision = c.getBeforeRevision();
                        if (!(beforeRevision != null && c.getAfterRevision() == null ? RefreshIncomingChangesOperation.isFileDeleted(file2, beforeRevision.getFile()) : beforeRevision != null && c.getAfterRevision() != null && RefreshIncomingChangesOperation.isParentReplacedOrFileMoved(file2, c, beforeRevision.getFile()))) continue;
                        return true;
                    }
                    indexOffset += 26L;
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            return false;
        }

        private static boolean isParentReplacedOrFileMoved(@NotNull FilePath file2, @NotNull Change change, @NotNull FilePath beforeFile) {
            boolean underBefore;
            boolean isParentReplaced = change.isIsReplaced() && !file2.equals(beforeFile);
            boolean isMovedRenamed = change.isMoved() || change.isRenamed();
            boolean bl = underBefore = (isParentReplaced || isMovedRenamed) && file2.isUnder(beforeFile, false);
            if (underBefore && isParentReplaced) {
                ChangesCacheFile.debug("For " + file2 + "some of parents is replaced: " + beforeFile);
                return true;
            }
            if (underBefore && isMovedRenamed) {
                ChangesCacheFile.debug("For " + file2 + "some of parents was renamed/moved: " + beforeFile);
                return true;
            }
            return false;
        }

        private static boolean isFileDeleted(@NotNull FilePath file2, @NotNull FilePath beforeFile) {
            if (file2.getPath().equals(beforeFile.getPath()) || file2.isUnder(beforeFile, false)) {
                ChangesCacheFile.debug("Found subsequent deletion for file " + file2);
                return true;
            }
            return false;
        }

        private IndexEntry getIndexEntryAtOffset(long indexOffset) throws IOException {
            IndexEntry e = this.myIndexEntryCache.get(indexOffset);
            if (e == null) {
                this.myChangesCacheFile.myIndexStream.seek(indexOffset);
                e = new IndexEntry();
                this.myChangesCacheFile.readIndexEntry(e);
                this.myIndexEntryCache.put(indexOffset, e);
            }
            return e;
        }

        private CommittedChangeList getChangeListAtOffset(long offset) throws IOException {
            CommittedChangeList changeList = this.myPreviousChangeListsCache.get(offset);
            if (changeList == null) {
                changeList = this.myChangesCacheFile.loadChangeListAt(offset);
                this.myPreviousChangeListsCache.put(offset, changeList);
            }
            return changeList;
        }

        private static boolean isDeletedFile(Set<FilePath> deletedFiles, ContentRevision afterRevision, Set<FilePath> replacedFiles) {
            FilePath file2 = afterRevision.getFile();
            while (file2 != null) {
                if (deletedFiles.contains(file2)) {
                    return true;
                }
                if ((file2 = file2.getParentPath()) == null || !replacedFiles.contains(file2)) continue;
                return true;
            }
            return false;
        }

        private static class ProcessingResult {
            final boolean changeFound;
            final IncomingChangeState.State state;
            final VirtualFile file;
            final Function<VcsRevisionNumber, ProcessingResult> revisionDependentProcessing;

            private ProcessingResult(boolean changeFound, IncomingChangeState.State state) {
                this.changeFound = changeFound;
                this.state = state;
                this.file = null;
                this.revisionDependentProcessing = null;
            }

            private ProcessingResult(VirtualFile file2, Function<VcsRevisionNumber, ProcessingResult> revisionDependentProcessing) {
                this.file = file2;
                this.revisionDependentProcessing = revisionDependentProcessing;
                this.changeFound = false;
                this.state = null;
            }
        }
    }

    private class BackIterator
    implements Iterator<ChangesBunch> {
        private final int bunchSize;
        private long myOffset;

        private BackIterator(int bunchSize) {
            this.bunchSize = bunchSize;
            try {
                try {
                    ChangesCacheFile.this.openStreams();
                    this.myOffset = ChangesCacheFile.this.myIndexStream.length() / 26L;
                }
                finally {
                    ChangesCacheFile.this.closeStreams();
                }
            }
            catch (IOException e) {
                this.myOffset = -1L;
            }
        }

        @Override
        public boolean hasNext() {
            return this.myOffset > 0L;
        }

        @Override
        @Nullable
        public ChangesBunch next() {
            try {
                int size;
                if (this.myOffset < (long)this.bunchSize) {
                    size = (int)this.myOffset;
                    this.myOffset = 0L;
                } else {
                    this.myOffset -= (long)this.bunchSize;
                    size = this.bunchSize;
                }
                return new ChangesBunch(ChangesCacheFile.this.readChangesInterval(this.myOffset, size), true);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

