/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.pom.Navigatable;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class EditSourceFromChangesBrowserAction
extends EditSourceAction {
    private final Icon myEditSourceIcon = AllIcons.Actions.EditSource;

    EditSourceFromChangesBrowserAction() {
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        event.getPresentation().setIcon(this.myEditSourceIcon);
        event.getPresentation().setText("Edit Source");
        if (event.getData(ChangesBrowserBase.DATA_KEY) == null) {
            event.getPresentation().setEnabledAndVisible(false);
        } else if (!ModalityState.NON_MODAL.equals(ModalityState.current()) || CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(event.getDataContext()))) {
            event.getPresentation().setEnabled(false);
        }
    }

    @Override
    protected Navigatable[] getNavigatables(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Change[] changes2 = (Change[])VcsDataKeys.SELECTED_CHANGES.getData(dataContext);
        return changes2 != null && project != null ? ChangesUtil.getNavigatableArray((Project)project, (Stream)ChangesUtil.getFiles(Stream.of(changes2))) : null;
    }
}

