/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ColumnFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.changes.committed.StructureFilteringStrategy;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SelectFilteringAction
extends LabeledComboBoxAction
implements DumbAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommittedChangesTreeBrowser myBrowser;
    @NotNull
    private ChangeListFilteringStrategy myPreviousSelection;

    public SelectFilteringAction(@NotNull Project project, @NotNull CommittedChangesTreeBrowser browser2) {
        super(VcsBundle.message((String)"committed.changes.filter.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myBrowser = browser2;
        this.myPreviousSelection = ChangeListFilteringStrategy.NONE;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setText(this.myPreviousSelection.toString());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        return new DefaultActionGroup(ContainerUtil.map(this.collectStrategies(), (Function)((NotNullFunction)strategy -> new SetFilteringAction((ChangeListFilteringStrategy)strategy))));
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        return action -> ((SetFilteringAction)((Object)action)).myStrategy.getKey().equals((Object)this.myPreviousSelection.getKey());
    }

    @NotNull
    private List<ChangeListFilteringStrategy> collectStrategies() {
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add(ChangeListFilteringStrategy.NONE);
        result2.add(new StructureFilteringStrategy(this.myProject));
        boolean addNameFilter = false;
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (provider == null) continue;
            addNameFilter = true;
            for (ChangeListColumn column : provider.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column)) continue;
                result2.add(new ColumnFilteringStrategy(column, provider.getClass()));
            }
        }
        if (addNameFilter) {
            result2.add(new ColumnFilteringStrategy(ChangeListColumn.NAME, CommittedChangesProvider.class));
        }
        return result2;
    }

    private class SetFilteringAction
    extends DumbAwareAction {
        @NotNull
        private final ChangeListFilteringStrategy myStrategy;

        private SetFilteringAction(ChangeListFilteringStrategy strategy) {
            super(strategy.toString());
            this.myStrategy = strategy;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (!ChangeListFilteringStrategy.NONE.equals(SelectFilteringAction.this.myPreviousSelection)) {
                SelectFilteringAction.this.myBrowser.removeFilteringStrategy(SelectFilteringAction.this.myPreviousSelection.getKey());
            }
            if (!ChangeListFilteringStrategy.NONE.equals(this.myStrategy)) {
                SelectFilteringAction.this.myBrowser.setFilteringStrategy(this.myStrategy);
            }
            SelectFilteringAction.this.myPreviousSelection = this.myStrategy;
        }
    }
}

