/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;
    private final ChangeListManagerImpl myManager;

    public ChangelistConflictAccessProvider(Project project, ChangeListManagerImpl manager) {
        this.myProject = project;
        this.myManager = manager;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        ChangelistConflictTracker.Options options = this.myManager.getConflictTracker().getOptions();
        if (!options.SHOW_DIALOG) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null || this.myManager.getConflictTracker().isWritingAllowed(virtualFile)) continue;
            denied.add(virtualFile);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog2;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> arrayList = new ArrayList<Change>();
            for (VirtualFile file3 : denied) {
                changeLists.add(this.myManager.getChangeList(file3));
                arrayList.add(this.myManager.getChange(file3));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog2 = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog2.show();
            } while (dialog2.isOK() && !dialog2.getResolution().resolveConflict(this.myProject, arrayList, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog2.isOK()) {
                options.LAST_RESOLUTION = dialog2.getResolution();
                return Collections.emptyList();
            }
        }
        return denied;
    }
}

