/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictTracker {
    private final Map<String, Conflict> myConflicts = Collections.synchronizedMap(new LinkedHashMap());
    private final Options myOptions = new Options();
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final EditorNotifications myEditorNotifications;
    private final ChangeListAdapter myChangeListListener;
    private final FileDocumentManager myDocumentManager;
    private final DocumentListener myDocumentListener;
    private final FileStatusManager myFileStatusManager;
    private final Set<VirtualFile> myCheckSet;
    private final Object myCheckSetLock;
    private final AtomicBoolean myShouldIgnoreModifications = new AtomicBoolean(false);

    public ChangelistConflictTracker(@NotNull Project project, @NotNull ChangeListManager changeListManager, @NotNull FileStatusManager fileStatusManager, @NotNull EditorNotifications editorNotifications) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myEditorNotifications = editorNotifications;
        this.myDocumentManager = FileDocumentManager.getInstance();
        this.myFileStatusManager = fileStatusManager;
        this.myCheckSetLock = new Object();
        this.myCheckSet = new HashSet();
        Application application = ApplicationManager.getApplication();
        final ZipperUpdater zipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        final Runnable runnable2 = () -> {
            HashSet localSet;
            if (application.isDisposed() || this.myProject.isDisposed() || !this.myProject.isOpen()) {
                return;
            }
            Object object = this.myCheckSetLock;
            synchronized (object) {
                localSet = new HashSet();
                localSet.addAll(this.myCheckSet);
                this.myCheckSet.clear();
            }
            this.checkFiles((Collection<? extends VirtualFile>)localSet);
        };
        this.myDocumentListener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(@NotNull DocumentEvent e) {
                if (!ChangelistConflictTracker.this.myOptions.isTrackingEnabled() || ChangelistConflictTracker.this.myShouldIgnoreModifications.get()) {
                    return;
                }
                Document document = e.getDocument();
                VirtualFile file2 = ChangelistConflictTracker.this.myDocumentManager.getFile(document);
                if (file2 != null && ProjectUtil.guessProjectForFile((VirtualFile)file2) == ChangelistConflictTracker.this.myProject) {
                    Object object = ChangelistConflictTracker.this.myCheckSetLock;
                    synchronized (object) {
                        ChangelistConflictTracker.this.myCheckSet.add(file2);
                    }
                    zipperUpdater.queue(runnable2);
                }
            }
        };
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListChanged(ChangeList list2) {
                if (((LocalChangeList)list2).isDefault()) {
                    ChangelistConflictTracker.this.clearChanges(list2.getChanges());
                }
            }

            public void changesMoved(Collection<Change> changes2, ChangeList fromList, ChangeList toList) {
                if (((LocalChangeList)toList).isDefault() || ((LocalChangeList)fromList).isDefault()) {
                    ChangelistConflictTracker.this.clearChanges(changes2);
                }
            }

            public void changesRemoved(Collection<Change> changes2, ChangeList fromList) {
                ChangelistConflictTracker.this.clearChanges(changes2);
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                ChangelistConflictTracker.this.clearChanges(newDefaultList.getChanges());
            }
        };
    }

    public void setIgnoreModifications(boolean value) {
        this.myShouldIgnoreModifications.set(value);
    }

    private void checkFiles(Collection<? extends VirtualFile> files2) {
        this.myChangeListManager.invokeAfterUpdate(() -> {
            LocalChangeList list2 = this.myChangeListManager.getDefaultChangeList();
            for (VirtualFile file2 : files2) {
                this.checkOneFile(file2, list2);
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOneFile(@NotNull VirtualFile file2, @NotNull LocalChangeList defaultList) {
        if (!this.shouldDetectConflictsFor(file2)) {
            return;
        }
        LocalChangeList changeList = this.myChangeListManager.getChangeList(file2);
        if (changeList == null || Comparing.equal((Object)changeList, (Object)defaultList) || ChangesUtil.isInternalOperation((VirtualFile)file2)) {
            return;
        }
        String path = file2.getPath();
        boolean newConflict = false;
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            Conflict conflict = this.myConflicts.get(path);
            if (conflict == null) {
                conflict = new Conflict();
                this.myConflicts.put(path, conflict);
                newConflict = true;
            }
        }
        if (newConflict && this.myOptions.HIGHLIGHT_CONFLICTS) {
            this.myFileStatusManager.fileStatusChanged(file2);
            this.myEditorNotifications.updateNotifications(file2);
        }
    }

    public boolean isWritingAllowed(@NotNull VirtualFile file2) {
        if (this.isFromActiveChangelist(file2)) {
            return true;
        }
        Conflict conflict = this.myConflicts.get(file2.getPath());
        return conflict != null && conflict.ignored;
    }

    public boolean isFromActiveChangelist(VirtualFile file2) {
        List changeLists = this.myChangeListManager.getChangeLists(file2);
        return changeLists.isEmpty() || ContainerUtil.exists((Iterable)changeLists, list2 -> list2.isDefault());
    }

    public boolean shouldDetectConflictsFor(@NotNull VirtualFile file2) {
        return !LineStatusTrackerManager.getInstance(this.myProject).arePartialChangelistsEnabled(file2);
    }

    private void clearChanges(Collection<? extends Change> changes2) {
        for (Change change : changes2) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            FilePath filePath = revision.getFile();
            String path = filePath.getPath();
            Conflict wasRemoved = this.myConflicts.remove(path);
            VirtualFile file2 = filePath.getVirtualFile();
            if (file2 == null) continue;
            if (wasRemoved != null) {
                this.myEditorNotifications.updateNotifications(file2);
            }
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    public void startTracking() {
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myDocumentListener, (Disposable)this.myProject);
    }

    public void stopTracking() {
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(Element to) {
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            for (Map.Entry<String, Conflict> entry : this.myConflicts.entrySet()) {
                Element fileElement = new Element("file");
                fileElement.setAttribute("path", entry.getKey());
                fileElement.setAttribute("ignored", Boolean.toString(entry.getValue().ignored));
                to.addContent(fileElement);
            }
        }
        XmlSerializer.serializeInto((Object)this.myOptions, (Element)to);
    }

    public void loadState(Element from) {
        this.myConflicts.clear();
        List files2 = from.getChildren("file");
        for (Object file2 : files2) {
            VirtualFile vf;
            Element element = (Element)file2;
            String path = element.getAttributeValue("path");
            if (path == null || (vf = LocalFileSystem.getInstance().findFileByIoFile(new File(path))) == null || this.myChangeListManager.getChangeList(vf) == null) continue;
            Conflict conflict = new Conflict();
            conflict.ignored = Boolean.parseBoolean(element.getAttributeValue("ignored"));
            this.myConflicts.put(path, conflict);
        }
        XmlSerializer.deserializeInto((Object)this.myOptions, (Element)from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsChanged() {
        HashMap<String, Conflict> copyMap;
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            copyMap = new HashMap<String, Conflict>(this.myConflicts);
        }
        for (Map.Entry entry : copyMap.entrySet()) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath((String)entry.getKey());
            if (file2 == null) continue;
            this.myFileStatusManager.fileStatusChanged(file2);
            this.myEditorNotifications.updateNotifications(file2);
        }
    }

    public Map<String, Conflict> getConflicts() {
        return this.myConflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getIgnoredConflicts() {
        Map<String, Conflict> map2 = this.myConflicts;
        synchronized (map2) {
            return ContainerUtil.mapNotNull(this.myConflicts.entrySet(), entry -> ((Conflict)entry.getValue()).ignored ? (String)entry.getKey() : null);
        }
    }

    public boolean hasConflict(@NotNull VirtualFile file2) {
        if (!this.myOptions.isTrackingEnabled()) {
            return false;
        }
        String path = file2.getPath();
        Conflict conflict = this.myConflicts.get(path);
        if (conflict != null && !conflict.ignored) {
            if (!this.shouldDetectConflictsFor(file2) || this.isFromActiveChangelist(file2)) {
                this.myConflicts.remove(path);
                return false;
            }
            return true;
        }
        return false;
    }

    public void ignoreConflict(@NotNull VirtualFile file2, boolean ignore) {
        String path = file2.getPath();
        Conflict conflict = this.myConflicts.get(path);
        if (conflict == null) {
            conflict = new Conflict();
            this.myConflicts.put(path, conflict);
        }
        conflict.ignored = ignore;
        this.myEditorNotifications.updateNotifications(file2);
        this.myFileStatusManager.fileStatusChanged(file2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ChangeListManager getChangeListManager() {
        return this.myChangeListManager;
    }

    public Options getOptions() {
        return this.myOptions;
    }

    public static class Options {
        public boolean SHOW_DIALOG = false;
        public boolean HIGHLIGHT_CONFLICTS = true;
        public boolean HIGHLIGHT_NON_ACTIVE_CHANGELIST = false;
        public ChangelistConflictResolution LAST_RESOLUTION = ChangelistConflictResolution.IGNORE;

        public boolean isTrackingEnabled() {
            return this.SHOW_DIALOG || this.HIGHLIGHT_CONFLICTS;
        }
    }

    public static class Conflict {
        boolean ignored;
    }
}

