/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeLinkMouseListener
extends LinkMouseListenerBase {
    private final ColoredTreeCellRenderer myRenderer;
    protected WeakReference<TreeNode> myLastHitNode;

    public TreeLinkMouseListener(ColoredTreeCellRenderer renderer2) {
        this.myRenderer = renderer2;
    }

    protected void showTooltip(JTree tree, MouseEvent e, HaveTooltip launcher) {
        String newText;
        String text = tree.getToolTipText(e);
        String string = newText = launcher == null ? null : launcher.getTooltip();
        if (!Comparing.equal((String)text, (String)newText)) {
            tree.setToolTipText(newText);
        }
    }

    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        Object tag = null;
        HaveTooltip haveTooltip = null;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            int dx = this.getRendererRelativeX(e, tree, path);
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            AppUIUtil.targetToDevice((Component)this.myRenderer, tree);
            if (this.myLastHitNode == null || this.myLastHitNode.get() != treeNode || e.getButton() != 0) {
                if (this.doCacheLastNode()) {
                    this.myLastHitNode = new WeakReference<TreeNode>(treeNode);
                }
                this.myRenderer.getTreeCellRendererComponent(tree, (Object)treeNode, false, false, treeNode.isLeaf(), tree.getRowForPath(path), false);
            }
            if ((tag = this.myRenderer.getFragmentTagAt(dx)) != null && treeNode instanceof HaveTooltip) {
                haveTooltip = (HaveTooltip)((Object)treeNode);
            }
        }
        this.showTooltip(tree, e, haveTooltip);
        return tag;
    }

    protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path) {
        Rectangle rectangle = tree.getPathBounds(path);
        assert (rectangle != null);
        return e.getX() - rectangle.x;
    }

    protected boolean doCacheLastNode() {
        return true;
    }

    public static interface HaveTooltip {
        public String getTooltip();
    }
}

