/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddList
implements ChangeListCommand {
    @NotNull
    private final String myName;
    @Nullable
    private final String myComment;
    @Nullable
    private final ChangeListData myData;
    private boolean myWasListCreated;
    private LocalChangeList myNewListCopy;
    private String myOldComment;

    public AddList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        this.myName = name;
        this.myComment = comment;
        this.myData = data;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList list2 = worker.getChangeListByName(this.myName);
        if (list2 == null) {
            String id = this.myNewListCopy != null ? this.myNewListCopy.getId() : null;
            this.myWasListCreated = true;
            this.myOldComment = null;
            this.myNewListCopy = worker.addChangeList(this.myName, this.myComment, id, this.myData);
        } else if (StringUtil.isNotEmpty((String)this.myComment)) {
            this.myWasListCreated = false;
            this.myOldComment = worker.editComment(this.myName, this.myComment);
            this.myNewListCopy = worker.getChangeListByName(this.myName);
        } else {
            this.myWasListCreated = false;
            this.myOldComment = null;
            this.myNewListCopy = list2;
        }
    }

    @Override
    public void doNotify(EventDispatcher<? extends ChangeListListener> dispatcher) {
        if (this.myWasListCreated) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListAdded((ChangeList)this.myNewListCopy);
        } else if (this.myOldComment != null) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListCommentChanged((ChangeList)this.myNewListCopy, this.myOldComment);
        }
    }

    @NotNull
    public LocalChangeList getNewListCopy() {
        return this.myNewListCopy;
    }
}

