/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchFromClipboardAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        String text = ClipboardUtil.getTextInClipboard();
        e.getPresentation().setEnabled(project != null && text != null && ChangeListManager.getInstance((Project)project).isFreezed() == null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        String clipboardText = ClipboardUtil.getTextInClipboard();
        assert (clipboardText != null);
        new MyApplyPatchFromClipboardDialog(project, clipboardText).show();
    }

    public static class MyApplyPatchFromClipboardDialog
    extends ApplyPatchDifferentiatedDialog {
        public MyApplyPatchFromClipboardDialog(@NotNull Project project, @NotNull String clipboardText) {
            super(project, new ApplyPatchDefaultExecutor(project), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, (VirtualFile)new LightVirtualFile("clipboardPatchFile", (CharSequence)clipboardText), null, null, null, null, null, false);
        }

        @Nullable
        protected JComponent createDoNotAskCheckbox() {
            return MyApplyPatchFromClipboardDialog.createAnalyzeOnTheFlyOptionPanel();
        }

        @NotNull
        private static JCheckBox createAnalyzeOnTheFlyOptionPanel() {
            JCheckBox removeOptionCheckBox = new JCheckBox("Analyze and apply patch from clipboard on the fly");
            removeOptionCheckBox.setMnemonic(76);
            removeOptionCheckBox.setSelected(VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY);
            removeOptionCheckBox.addActionListener(e -> {
                VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY = removeOptionCheckBox.isSelected();
            });
            return removeOptionCheckBox;
        }
    }
}

