/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.patch.CommonBinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.SimpleBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryFilePatchInProgress
extends CommonBinaryFilePatchInProgress<BinaryFilePatch> {
    protected BinaryFilePatchInProgress(@NotNull BinaryFilePatch patch, @Nullable Collection<VirtualFile> autoBases, @NotNull VirtualFile baseDir) {
        super(patch.copy(), autoBases, baseDir);
    }

    @Override
    @NotNull
    protected BinaryContentRevision createNewContentRevision(@NotNull FilePath newFilePath) {
        return new SimpleBinaryContentRevision(newFilePath){

            @Nullable
            public byte[] getBinaryContent() {
                return ((BinaryFilePatch)BinaryFilePatchInProgress.this.myPatch).getAfterContent();
            }
        };
    }

    @Override
    @NotNull
    protected Change createChange(Project project) {
        CurrentBinaryContentRevision before = null;
        BinaryContentRevision after = null;
        if (!((BinaryFilePatch)this.myPatch).isNewFile()) {
            before = new CurrentBinaryContentRevision(this.getFilePath()){

                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    return new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                }
            };
        }
        if (!((BinaryFilePatch)this.myPatch).isDeletedFile()) {
            after = this.createNewContentRevision(this.getFilePath());
        }
        return new Change((ContentRevision)before, (ContentRevision)after);
    }
}

