/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class BlobIndexUtil {
    public static final String NOT_COMMITTED_HASH = StringUtil.repeat((String)"0", (int)40);

    @NotNull
    public static String getSha1(@NotNull File file2) throws IOException {
        return BlobIndexUtil.getSha1(Files.toByteArray((File)file2));
    }

    @NotNull
    public static String getSha1(@NotNull byte[] bytes) {
        String prefix = "blob " + bytes.length + '\u0000';
        return Hashing.sha1().newHasher().putBytes(prefix.getBytes(Charsets.UTF_8)).putBytes(bytes).hash().toString();
    }

    @NotNull
    public static Couple<String> getBeforeAfterSha1(@NotNull Change change) throws VcsException {
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        Charset detectCharset = ((ContentRevision)ObjectUtils.chooseNotNull((Object)afterRevision, (Object)beforeRevision)).getFile().getCharset();
        String before = beforeRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(beforeRevision, detectCharset));
        String after = afterRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(afterRevision, detectCharset));
        return new Couple((Object)before, (Object)after);
    }

    @NotNull
    private static byte[] getContentBytes(@NotNull ContentRevision revision, @NotNull Charset charset) throws VcsException {
        String stringContent;
        byte[] binaryContent = revision instanceof ByteBackedContentRevision ? ((ByteBackedContentRevision)revision).getContentAsBytes() : ((stringContent = revision.getContent()) != null ? stringContent.getBytes(charset) : ArrayUtil.EMPTY_BYTE_ARRAY);
        return binaryContent != null ? binaryContent : ArrayUtil.EMPTY_BYTE_ARRAY;
    }
}

