/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyPatchContentRevision
implements ContentRevision {
    private final VirtualFile myVf;
    private final FilePath myNewFilePath;
    private final String myRevision;
    private final TextFilePatch myPatch;
    private final AtomicNotNullLazyValue<Data> myData;

    public LazyPatchContentRevision(VirtualFile vf, FilePath newFilePath, String revision, TextFilePatch patch) {
        this.myVf = vf;
        this.myNewFilePath = newFilePath;
        this.myRevision = revision;
        this.myPatch = patch;
        this.myData = AtomicNotNullLazyValue.createValue(() -> this.loadContent());
    }

    private Data loadContent() {
        String localContext = (String)ReadAction.compute(() -> {
            Document doc = FileDocumentManager.getInstance().getDocument(this.myVf);
            return doc == null ? null : doc.getText();
        });
        if (localContext == null) {
            return new Data(null, true);
        }
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(localContext, this.myPatch.getHunks());
        if (appliedPatch != null) {
            return new Data(appliedPatch.patchedText, false);
        }
        return new Data(null, true);
    }

    @Nullable
    public String getContent() {
        return ((Data)this.myData.getValue()).content;
    }

    public boolean isPatchApplyFailed() {
        return ((Data)this.myData.getValue()).patchApplyFailed;
    }

    @NotNull
    public FilePath getFile() {
        return this.myNewFilePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return new VcsRevisionNumber(){

            public String asString() {
                return LazyPatchContentRevision.this.myRevision;
            }

            public int compareTo(VcsRevisionNumber o) {
                return 0;
            }
        };
    }

    private static class Data {
        @Nullable
        public final String content;
        public final boolean patchApplyFailed;

        Data(@Nullable String content, boolean patchApplyFailed) {
            this.content = content;
            this.patchApplyFailed = patchApplyFailed;
        }
    }
}

