/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.BinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vcs.changes.patch.ShelvedBinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchPatchPaths {
    private static final int BIG_FILE_BOUND = 100000;
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private boolean myUseProjectRootAsPredefinedBase;

    public MatchPatchPaths(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir();
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list2) {
        return this.execute(list2, false);
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list2, boolean useProjectRootAsPredefinedBase) {
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        ArrayList<PatchAndVariants> candidates = new ArrayList<PatchAndVariants>(list2.size());
        ArrayList newOrWithoutMatches = new ArrayList();
        this.findCandidates(list2, directoryDetector, candidates, newOrWithoutMatches);
        MultiMap result2 = new MultiMap();
        MatchPatchPaths.filterExactMatches(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        MatchPatchPaths.selectByContextOrByStrip(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        this.workWithNotExisting(directoryDetector, newOrWithoutMatches, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        return new ArrayList<AbstractFilePatchInProgress>(result2.values());
    }

    private void workWithNotExisting(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<? extends FilePatch> newOrWithoutMatches, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        for (FilePatch filePatch : newOrWithoutMatches) {
            AbstractFilePatchInProgress patchInProgress;
            String afterName = filePatch.getAfterName();
            String[] strings = MatchPatchPaths.getPathParts(afterName);
            FileBaseMatch best = null;
            boolean bestIsUnique = true;
            for (int i = strings.length - 2; i >= 0; --i) {
                String name = strings[i];
                Collection<VirtualFile> files2 = this.findFilesFromIndex(directoryDetector, name);
                if (files2.isEmpty()) continue;
                for (VirtualFile file2 : files2) {
                    FileBaseMatch match = MatchPatchPaths.compareNamesImpl(strings, file2, i);
                    if (match == null || match.score >= i) continue;
                    if (best == null || this.isBetterMatch(match, best)) {
                        best = match;
                        bestIsUnique = true;
                        continue;
                    }
                    if (match.file.equals(best.file) || this.isBetterMatch(best, match)) continue;
                    bestIsUnique = false;
                }
            }
            if (best != null && bestIsUnique) {
                patchInProgress = MatchPatchPaths.createPatchInProgress(filePatch, best.file);
                if (patchInProgress == null) break;
                MatchPatchPaths.processStipUp(patchInProgress, best.score);
                result2.putValue((Object)best.file, (Object)patchInProgress);
                continue;
            }
            patchInProgress = MatchPatchPaths.createPatchInProgress(filePatch, this.myBaseDir);
            if (patchInProgress == null) break;
            result2.putValue((Object)this.myBaseDir, (Object)patchInProgress);
        }
    }

    private boolean isBetterMatch(@NotNull FileBaseMatch match, @NotNull FileBaseMatch best) {
        return match.score < best.score || match.score == best.score && this.myBaseDir.equals(match.file);
    }

    private static void selectByContextOrByStrip(@NotNull List<? extends PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        for (PatchAndVariants patchAndVariants : candidates) {
            patchAndVariants.findAndAddBestVariant(result2);
        }
    }

    private static void filterExactMatches(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        Iterator<PatchAndVariants> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            PatchAndVariants candidate = iterator.next();
            if (candidate.getVariants().size() == 1) {
                AbstractFilePatchInProgress oneCandidate = candidate.getVariants().get(0);
                result2.putValue((Object)oneCandidate.getBase(), (Object)oneCandidate);
                iterator.remove();
                continue;
            }
            ArrayList<AbstractFilePatchInProgress> exact = new ArrayList<AbstractFilePatchInProgress>(candidate.getVariants().size());
            for (AbstractFilePatchInProgress patch : candidate.getVariants()) {
                if (patch.getCurrentStrip() != 0) continue;
                exact.add(patch);
            }
            if (exact.size() == 1) {
                AbstractFilePatchInProgress patchInProgress = (AbstractFilePatchInProgress)exact.get(0);
                MatchPatchPaths.putSelected(result2, candidate.getVariants(), patchInProgress);
                iterator.remove();
                continue;
            }
            if (exact.isEmpty()) continue;
            candidate.getVariants().retainAll(exact);
        }
    }

    private void findCandidates(@NotNull List<? extends FilePatch> list2, @NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<? super PatchAndVariants> candidates, @NotNull List<? super FilePatch> newOrWithoutMatches) {
        for (FilePatch filePatch : list2) {
            VirtualFile relativeFile;
            String fileName2 = filePatch.getBeforeFileName();
            if (filePatch.isNewFile() || filePatch.getBeforeName() == null) {
                newOrWithoutMatches.add((FilePatch)filePatch);
                continue;
            }
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(this.findFilesFromIndex(directoryDetector, fileName2));
            if (filePatch.getBeforeName() != null && filePatch.getBeforeName().startsWith("..") && (relativeFile = VfsUtil.findRelativeFile((VirtualFile)this.myBaseDir, (String[])MatchPatchPaths.getPathParts(filePatch.getBeforeName()))) != null) {
                files2.add(relativeFile);
            }
            if (files2.isEmpty()) {
                newOrWithoutMatches.add((FilePatch)filePatch);
                continue;
            }
            List variants = ContainerUtil.mapNotNull(files2, file2 -> MatchPatchPaths.processMatch(patch, file2));
            if (variants.isEmpty()) {
                newOrWithoutMatches.add((FilePatch)filePatch);
                continue;
            }
            candidates.add(new PatchAndVariants(variants));
        }
    }

    private Collection<VirtualFile> findFilesFromIndex(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull String fileName2) {
        Collection files2 = (Collection)ReadAction.compute(() -> directoryDetector.findFiles(fileName2));
        File shelfResourcesDirectory = ShelveChangesManager.getInstance(this.myProject).getShelfResourcesDirectory();
        return ContainerUtil.filter((Collection)files2, file2 -> !FileUtil.isAncestor((File)shelfResourcesDirectory, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)false));
    }

    private static void putSelected(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2, @NotNull List<? extends AbstractFilePatchInProgress> variants, @NotNull AbstractFilePatchInProgress patchInProgress) {
        patchInProgress.setAutoBases(ContainerUtil.mapNotNull(variants, AbstractFilePatchInProgress::getBase));
        result2.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
    }

    private static int getMatchingLines(AbstractFilePatchInProgress<TextFilePatch> patch) {
        String text;
        VirtualFile base = patch.getCurrentBase();
        if (base == null) {
            return -1;
        }
        try {
            text = base.getLength() > 100000L ? VfsUtilCore.loadText((VirtualFile)base, (int)100000) : VfsUtilCore.loadText((VirtualFile)base);
        }
        catch (IOException e) {
            return 0;
        }
        return new GenericPatchApplier(text, patch.getPatch().getHunks()).weightContextMatch(100, 5);
    }

    private boolean isBetterMatch(@NotNull AbstractFilePatchInProgress match, int matchLines, @NotNull AbstractFilePatchInProgress best, int bestLines) {
        return matchLines > bestLines || matchLines == bestLines && this.myBaseDir.equals(match.getBase());
    }

    private boolean variantMatchedToProjectDir(@NotNull AbstractFilePatchInProgress variant) {
        if (variant.getCurrentStrip() == 0) {
            return this.myBaseDir.equals(variant.getBase());
        }
        int upDirCount = 0;
        VirtualFile base = this.myBaseDir;
        for (String part : MatchPatchPaths.getPathParts(variant.getOriginalBeforePath())) {
            if (!part.equals("..")) break;
            ++upDirCount;
            if (base == null) continue;
            base = base.getParent();
        }
        return upDirCount == variant.getCurrentStrip() && base != null && base.equals(variant.getBase());
    }

    @Nullable
    private static FileBaseMatch compareNames(String beforeName, VirtualFile file2) {
        if (beforeName == null) {
            return null;
        }
        String[] parts = MatchPatchPaths.getPathParts(beforeName);
        return MatchPatchPaths.compareNamesImpl(parts, file2.getParent(), parts.length - 2);
    }

    @NotNull
    private static String[] getPathParts(@Nullable String relativePath) {
        if (relativePath == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return relativePath.replace('\\', '/').split("/");
    }

    @Nullable
    private static FileBaseMatch compareNamesImpl(String[] parts, VirtualFile parent, int idx) {
        while (parent != null && idx >= 0 && parent.getName().equals(parts[idx])) {
            parent = parent.getParent();
            --idx;
        }
        return parent != null ? new FileBaseMatch(parent, idx + 1) : null;
    }

    @Nullable
    private static AbstractFilePatchInProgress processMatch(FilePatch patch, VirtualFile file2) {
        String beforeName = patch.getBeforeName();
        FileBaseMatch match = MatchPatchPaths.compareNames(beforeName, file2);
        if (match == null) {
            return null;
        }
        AbstractFilePatchInProgress result2 = MatchPatchPaths.createPatchInProgress(patch, match.file);
        if (result2 != null) {
            MatchPatchPaths.processStipUp(result2, match.score);
        }
        return result2;
    }

    @Nullable
    private static AbstractFilePatchInProgress createPatchInProgress(@NotNull FilePatch patch, @NotNull VirtualFile dir) {
        if (patch instanceof TextFilePatch) {
            return new TextFilePatchInProgress((TextFilePatch)patch, null, dir);
        }
        if (patch instanceof ShelvedBinaryFilePatch) {
            return new ShelvedBinaryFilePatchInProgress((ShelvedBinaryFilePatch)patch, null, dir);
        }
        if (patch instanceof BinaryFilePatch) {
            return new BinaryFilePatchInProgress((BinaryFilePatch)patch, null, dir);
        }
        return null;
    }

    private static void processStipUp(AbstractFilePatchInProgress patchInProgress, int num) {
        for (int i = 0; i < num; ++i) {
            patchInProgress.up();
        }
    }

    private static class FileBaseMatch {
        @NotNull
        public final VirtualFile file;
        public final int score;

        FileBaseMatch(@NotNull VirtualFile file2, int score) {
            this.file = file2;
            this.score = score;
        }
    }

    private class PatchAndVariants {
        @NotNull
        private final List<AbstractFilePatchInProgress> myVariants;

        private PatchAndVariants(List<AbstractFilePatchInProgress> variants) {
            this.myVariants = variants;
        }

        @NotNull
        public List<AbstractFilePatchInProgress> getVariants() {
            return this.myVariants;
        }

        public void findAndAddBestVariant(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
            AbstractFilePatchInProgress first = (AbstractFilePatchInProgress)ContainerUtil.getFirstItem(this.myVariants);
            if (first == null) {
                return;
            }
            AbstractFilePatchInProgress best = null;
            if (first instanceof TextFilePatchInProgress) {
                if (MatchPatchPaths.this.myUseProjectRootAsPredefinedBase) {
                    best = this.findBestByBaseDir();
                }
                if (best == null) {
                    best = this.findBestByText();
                }
            } else {
                best = this.findBestByBaseDir();
                if (best == null) {
                    best = this.findBestByStrip();
                }
            }
            if (best != null) {
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2, this.myVariants, best);
            }
        }

        @Nullable
        private AbstractFilePatchInProgress findBestByBaseDir() {
            for (AbstractFilePatchInProgress variant : this.myVariants) {
                if (!MatchPatchPaths.this.variantMatchedToProjectDir(variant)) continue;
                return variant;
            }
            return null;
        }

        @Nullable
        private AbstractFilePatchInProgress findBestByText() {
            TextFilePatchInProgress best = null;
            int bestLines = Integer.MIN_VALUE;
            boolean bestIsUnique = true;
            TextFilePatchInProgress baseDirVariant = null;
            for (AbstractFilePatchInProgress variant : this.myVariants) {
                TextFilePatchInProgress current = (TextFilePatchInProgress)variant;
                int currentLines = MatchPatchPaths.getMatchingLines(current);
                if (best == null || MatchPatchPaths.this.isBetterMatch(current, currentLines, best, bestLines)) {
                    bestLines = currentLines;
                    best = current;
                    bestIsUnique = true;
                } else if (!MatchPatchPaths.this.isBetterMatch(best, bestLines, current, currentLines)) {
                    bestIsUnique = false;
                }
                if (baseDirVariant != null || !MatchPatchPaths.this.myBaseDir.equals(current.getBase())) continue;
                baseDirVariant = current;
            }
            if (!bestIsUnique && baseDirVariant != null) {
                return baseDirVariant;
            }
            return best;
        }

        @Nullable
        private AbstractFilePatchInProgress findBestByStrip() {
            AbstractFilePatchInProgress best = null;
            int bestStrip = Integer.MAX_VALUE;
            for (AbstractFilePatchInProgress current : this.myVariants) {
                int currentStrip = current.getCurrentStrip();
                if (best != null && currentStrip >= bestStrip) continue;
                best = current;
                bestStrip = currentStrip;
            }
            return best;
        }
    }
}

