/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchFromClipboardAction;
import com.intellij.openapi.wm.IdeFrame;
import org.jetbrains.annotations.NotNull;

public class PatchClipboardTracker
implements ApplicationInitializedListener {
    public void componentsInitialized() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new PatchClipboardListener());
    }

    private static class PatchClipboardListener
    extends ClipboardAnalyzeListener {
        private PatchClipboardListener() {
        }

        @Override
        public void applicationActivated(@NotNull IdeFrame ideFrame) {
            if (!VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY) {
                return;
            }
            super.applicationActivated(ideFrame);
        }

        @Override
        public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
            if (!VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY) {
                return;
            }
            super.applicationDeactivated(ideFrame);
        }

        @Override
        protected void handle(@NotNull Project project, @NotNull String value) {
            new ApplyPatchFromClipboardAction.MyApplyPatchFromClipboardDialog(project, value).show();
        }

        @Override
        public boolean canHandle(@NotNull String value) {
            return PatchReader.isPatchContent(value);
        }
    }
}

