/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.LazyPatchContentRevision;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextFilePatchInProgress
extends AbstractFilePatchInProgress<TextFilePatch> {
    protected TextFilePatchInProgress(TextFilePatch patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch.pathsOnlyCopy(), autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision == null) {
            this.myConflicts = null;
            if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
                FilePath newFilePath = VcsUtil.getFilePath((File)this.myIoCurrentBase, (boolean)false);
                String content = ((TextFilePatch)this.myPatch).getSingleHunkPatchText();
                this.myNewContentRevision = new SimpleContentRevision(content, newFilePath, ((TextFilePatch)this.myPatch).getAfterVersionId());
            } else {
                FilePath newFilePath = this.detectNewFilePathForMovedOrModified();
                this.myNewContentRevision = new LazyPatchContentRevision(this.myCurrentBase, newFilePath, ((TextFilePatch)this.myPatch).getAfterVersionId(), (TextFilePatch)this.myPatch);
            }
        }
        return this.myNewContentRevision;
    }

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project, final PatchReader patchReader) {
        final AbstractFilePatchInProgress.PatchChange change = this.getChange();
        Object patch = this.getPatch();
        final String path = patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName();
        return new DiffRequestProducer(){

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (TextFilePatchInProgress.this.myCurrentBase != null && TextFilePatchInProgress.this.myCurrentBase.getFileType() == UnknownFileType.INSTANCE) {
                    return new UnknownFileTypeDiffRequest(TextFilePatchInProgress.this.myCurrentBase, this.getName());
                }
                if (TextFilePatchInProgress.this.isConflictingChange()) {
                    VirtualFile file2 = TextFilePatchInProgress.this.getCurrentBase();
                    ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(project, file2, VcsUtil.getFilePath((VirtualFile)file2), (TextFilePatch)TextFilePatchInProgress.this.getPatch(), patchReader.getBaseRevision(project, path));
                    String afterTitle = ((TextFilePatch)TextFilePatchInProgress.this.getPatch()).getAfterVersionId();
                    if (afterTitle == null) {
                        afterTitle = "Patched Version";
                    }
                    return PatchDiffRequestFactory.createConflictDiffRequest(project, file2, (TextFilePatch)TextFilePatchInProgress.this.getPatch(), afterTitle, texts, this.getName());
                }
                return PatchDiffRequestFactory.createDiffRequest(project, change, this.getName(), context, indicator);
            }

            @NotNull
            public String getName() {
                File ioCurrentBase = TextFilePatchInProgress.this.getIoCurrentBase();
                return ioCurrentBase == null ? TextFilePatchInProgress.this.getCurrentPath() : ioCurrentBase.getPath();
            }
        };
    }
}

