/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchChange {
    @NotNull
    private final ApplyPatchViewer myViewer;
    private final int myIndex;
    @NotNull
    private final LineRange myPatchDeletionRange;
    @NotNull
    private final LineRange myPatchInsertionRange;
    @NotNull
    private final AppliedTextPatch.HunkStatus myStatus;
    @Nullable
    private final List<DiffFragment> myPatchInnerDifferences;
    @NotNull
    private final List<MyGutterOperation> myOperations = new ArrayList<MyGutterOperation>();
    @NotNull
    private final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    private boolean myResolved;

    ApplyPatchChange(@NotNull PatchChangeBuilder.Hunk hunk, int index, @NotNull ApplyPatchViewer viewer) {
        this.myIndex = index;
        this.myViewer = viewer;
        this.myPatchDeletionRange = hunk.getPatchDeletionRange();
        this.myPatchInsertionRange = hunk.getPatchInsertionRange();
        this.myStatus = hunk.getStatus();
        DocumentEx patchDocument = viewer.getPatchEditor().getDocument();
        this.myPatchInnerDifferences = PatchChangeBuilder.computeInnerDifferences(patchDocument, hunk);
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.myViewer.repaintDivider();
    }

    private void installHighlighters() {
        this.createResultHighlighters();
        this.createPatchHighlighters();
        this.createStatusHighlighter();
        this.createOperations();
    }

    private void createPatchHighlighters() {
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(patchEditor, this.myPatchDeletionRange, this.myPatchInsertionRange, this.myPatchInnerDifferences));
    }

    private void createResultHighlighters() {
        LineRange resultRange = this.getResultRange();
        if (resultRange == null) {
            return;
        }
        EditorEx editor = this.myViewer.getResultEditor();
        int startLine = resultRange.start;
        int endLine = resultRange.end;
        TextDiffType type = this.getDiffType();
        boolean resolved = this.isRangeApplied();
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, startLine, endLine, type, false, resolved, false, false, false));
    }

    private void createStatusHighlighter() {
        int line1 = this.myPatchDeletionRange.start;
        int line2 = this.myPatchInsertionRange.end;
        Color color = this.getStatusColor();
        if (this.isResolved()) {
            color = ColorUtil.mix((Color)color, (Color)this.myViewer.getPatchEditor().getGutterComponentEx().getBackground(), (double)0.6f);
        }
        String tooltip = this.getStatusText();
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        DocumentEx document = patchEditor.getDocument();
        MarkupModelEx markupModel = patchEditor.getMarkupModel();
        TextRange textRange = DiffUtil.getLinesRange(document, line1, line2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyGutterRenderer(line1, line2, color, tooltip));
        this.myHighlighters.add(highlighter);
    }

    private void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public AppliedTextPatch.HunkStatus getStatus() {
        return this.myStatus;
    }

    @NotNull
    public LineRange getPatchRange() {
        return new LineRange(this.myPatchDeletionRange.start, this.myPatchInsertionRange.end);
    }

    @NotNull
    public LineRange getPatchAffectedRange() {
        return this.isRangeApplied() ? this.myPatchInsertionRange : this.myPatchDeletionRange;
    }

    @NotNull
    public LineRange getPatchDeletionRange() {
        return this.myPatchDeletionRange;
    }

    @NotNull
    public LineRange getPatchInsertionRange() {
        return this.myPatchInsertionRange;
    }

    @Nullable
    public LineRange getResultRange() {
        ApplyPatchViewer.MyModel model = this.myViewer.getModel();
        int lineStart = model.getLineStart(this.myIndex);
        int lineEnd = model.getLineEnd(this.myIndex);
        if (lineStart != -1 || lineEnd != -1) {
            return new LineRange(lineStart, lineEnd);
        }
        return null;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    @NotNull
    public TextDiffType getDiffType() {
        return DiffUtil.getDiffType(!this.myPatchDeletionRange.isEmpty(), !this.myPatchInsertionRange.isEmpty());
    }

    public boolean isRangeApplied() {
        return this.myResolved || this.getStatus() == AppliedTextPatch.HunkStatus.ALREADY_APPLIED;
    }

    @NotNull
    private String getStatusText() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                return "Already applied";
            }
            case EXACTLY_APPLIED: {
                return "Automatically applied";
            }
            case NOT_APPLIED: {
                return "Not applied";
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private Color getStatusColor() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                return JBColor.YELLOW.darker();
            }
            case EXACTLY_APPLIED: {
                return new JBColor(new Color(0, 180, 5), new Color(0, 147, 5));
            }
            case NOT_APPLIED: {
                return JBColor.RED.darker();
            }
        }
        throw new IllegalStateException();
    }

    private void createOperations() {
        if (this.myViewer.isReadOnly()) {
            return;
        }
        if (this.isResolved()) {
            return;
        }
        if (this.myStatus == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.APPLY));
        }
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.IGNORE));
    }

    @Nullable
    private MyGutterOperation createOperation(@NotNull OperationType type) {
        if (this.isResolved()) {
            return null;
        }
        int line = this.getPatchRange().start;
        EditorEx editor = this.myViewer.getPatchEditor();
        DocumentEx document = editor.getDocument();
        int offset = line == DiffUtil.getLineCount(document) ? document.getTextLength() : document.getLineStartOffset(line);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(highlighter, type);
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), DiffUtil.getArrowIcon(Side.RIGHT), () -> this.myViewer.executeCommand("Accept change", () -> this.myViewer.replaceChange(this)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), AllIcons.Diff.Remove, () -> this.myViewer.executeCommand("Ignore change", () -> this.myViewer.markChangeResolved(this)));
    }

    @Nullable
    private static GutterIconRenderer createIconRenderer(@NotNull String text, @NotNull Icon icon, final @NotNull Runnable perform) {
        String tooltipText = DiffUtil.createTooltipText(text, null);
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void handleMouseClick() {
                perform.run();
            }
        };
    }

    @NotNull
    public State storeState() {
        LineRange resultRange = this.getResultRange();
        return new State(this.myIndex, resultRange != null ? resultRange.start : -1, resultRange != null ? resultRange.end : -1, this.myResolved);
    }

    public void restoreState(@NotNull State state) {
        this.myResolved = state.myResolved;
    }

    private class MyGutterRenderer
    implements ActiveGutterRenderer {
        private final int myLine1;
        private final int myLine2;
        private final Color myColor;
        private final String myTooltip;

        MyGutterRenderer(int line1, int line2, Color color, String tooltip) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myColor = color;
            this.myTooltip = tooltip;
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            LineStatusMarkerRenderer.paintSimpleRange(g, editor, this.myLine1, this.myLine2, this.myColor);
        }

        public String getTooltipText() {
            return this.myTooltip;
        }

        public boolean canDoAction(@NotNull MouseEvent e) {
            return LineStatusMarkerRenderer.isInsideMarkerArea(e);
        }

        public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            if (ApplyPatchChange.this.getResultRange() != null) {
                ApplyPatchChange.this.myViewer.scrollToChange(ApplyPatchChange.this, Side.RIGHT, false);
            }
        }

        @NotNull
        public String getAccessibleName() {
            return "marker: " + this.getTooltipText();
        }
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved;

        public State(int index, int startLine, int endLine, boolean resolved) {
            super(index, startLine, endLine);
            this.myResolved = resolved;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }

    private class MyGutterOperation {
        @NotNull
        private final RangeHighlighter myHighlighter;
        @NotNull
        private final OperationType myType;

        private MyGutterOperation(@NotNull RangeHighlighter highlighter, OperationType type) {
            this.myHighlighter = highlighter;
            this.myType = type;
            this.myHighlighter.setGutterIconRenderer(this.createRenderer());
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            switch (this.myType) {
                case APPLY: {
                    return ApplyPatchChange.this.createApplyRenderer();
                }
                case IGNORE: {
                    return ApplyPatchChange.this.createIgnoreRenderer();
                }
            }
            throw new IllegalArgumentException(this.myType.name());
        }
    }
}

