/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchRequest;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeRequest
extends MergeRequest
implements ApplyPatchRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myResultContent;
    @NotNull
    private final AppliedTextPatch myAppliedPatch;
    @NotNull
    private final CharSequence myOriginalContent;
    @NotNull
    private final String myLocalContent;
    @Nullable
    private final String myWindowTitle;
    @NotNull
    private final String myLocalTitle;
    @NotNull
    private final String myResultTitle;
    @NotNull
    private final String myPatchTitle;
    @Nullable
    private final Consumer<? super MergeResult> myCallback;

    public ApplyPatchMergeRequest(@Nullable Project project, @NotNull DocumentContent resultContent, @NotNull AppliedTextPatch appliedPatch, @NotNull String localContent, @Nullable String windowTitle, @NotNull String localTitle, @NotNull String resultTitle, @NotNull String patchTitle, @Nullable Consumer<? super MergeResult> callback2) {
        this.myProject = project;
        this.myResultContent = resultContent;
        this.myAppliedPatch = appliedPatch;
        this.myOriginalContent = (CharSequence)ReadAction.compute(() -> this.myResultContent.getDocument().getImmutableCharSequence());
        this.myLocalContent = localContent;
        this.myWindowTitle = windowTitle;
        this.myLocalTitle = localTitle;
        this.myResultTitle = resultTitle;
        this.myPatchTitle = patchTitle;
        this.myCallback = callback2;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public DocumentContent getResultContent() {
        return this.myResultContent;
    }

    @Override
    @NotNull
    public String getLocalContent() {
        return this.myLocalContent;
    }

    @Override
    @NotNull
    public AppliedTextPatch getPatch() {
        return this.myAppliedPatch;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myWindowTitle;
    }

    @Override
    @NotNull
    public String getLocalTitle() {
        return this.myLocalTitle;
    }

    @Override
    @NotNull
    public String getResultTitle() {
        return this.myResultTitle;
    }

    @Override
    @NotNull
    public String getPatchTitle() {
        return this.myPatchTitle;
    }

    public void applyResult(@NotNull MergeResult result2) {
        CharSequence applyContent;
        switch (result2) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                applyContent = this.myLocalContent;
                break;
            }
            case RIGHT: {
                throw new UnsupportedOperationException();
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result2.name());
            }
        }
        if (applyContent != null) {
            WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> this.myResultContent.getDocument().setText(applyContent));
        }
        if (this.myCallback != null) {
            this.myCallback.consume((Object)result2);
        }
    }
}

