/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final String DIFF_WITH_BASE_ERROR = "Base content not found or not applicable.";
    public static final String SHELVED_VERSION = "Shelved Version";
    public static final String BASE_VERSION = "Base Version";
    public static final String CURRENT_VERSION = "Current Version";

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY) != null || e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    public static void showShelvedChangesDiff(DataContext dc, boolean withLocal) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        ShelvedChangeList changeList = (ShelvedChangeList)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(changeLists));
        List<ShelvedChange> textChanges = changeList.getChanges(project);
        List<ShelvedBinaryFile> binaryChanges = changeList.getBinaryFiles();
        ArrayList diffRequestProducers = new ArrayList();
        DiffShelvedChangesActionProvider.processTextChanges(project, textChanges, diffRequestProducers, withLocal);
        DiffShelvedChangesActionProvider.processBinaryFiles(project, binaryChanges, diffRequestProducers);
        Collections.sort(diffRequestProducers, ChangeDiffRequestComparator.getInstance());
        HashSet<Object> selectedChanges = new HashSet<Object>();
        selectedChanges.addAll(ShelvedChangesViewManager.getShelveChanges(dc));
        selectedChanges.addAll(ShelvedChangesViewManager.getBinaryShelveChanges(dc));
        int index = 0;
        for (int i = 0; i < diffRequestProducers.size(); ++i) {
            ShelveDiffRequestProducer producer = (ShelveDiffRequestProducer)diffRequestProducers.get(i);
            if (!selectedChanges.contains(producer.getBinaryChange()) && !selectedChanges.contains(producer.getTextChange())) continue;
            index = i;
            break;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestProducers, index);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static void processBinaryFiles(@NotNull Project project, @NotNull List<? extends ShelvedBinaryFile> files2, @NotNull List<? super ShelveDiffRequestProducer> diffRequestProducers) {
        String base = project.getBasePath();
        for (ShelvedBinaryFile shelvedBinaryFile : files2) {
            File file2 = new File(base, shelvedBinaryFile.AFTER_PATH == null ? shelvedBinaryFile.BEFORE_PATH : shelvedBinaryFile.AFTER_PATH);
            FilePath filePath = VcsUtil.getFilePath((File)file2);
            diffRequestProducers.add(new BinaryShelveDiffRequestProducer(project, shelvedBinaryFile, filePath));
        }
    }

    private static void processTextChanges(@NotNull Project project, @NotNull List<? extends ShelvedChange> changesFromFirstList, @NotNull List<? super ShelveDiffRequestProducer> diffRequestProducers, boolean withLocal) {
        String base = project.getBasePath();
        ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        PatchesPreloader preloader = new PatchesPreloader(project);
        CommitContext commitContext = new CommitContext();
        for (ShelvedChange shelvedChange : changesFromFirstList) {
            String beforePath = shelvedChange.getBeforePath();
            String afterPath = shelvedChange.getAfterPath();
            FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
            try {
                if (FileStatus.ADDED.equals(shelvedChange.getFileStatus())) {
                    diffRequestProducers.add(new NewFileTextShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, commitContext, withLocal));
                    continue;
                }
                VirtualFile file2 = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath);
                if (file2 == null || !file2.exists()) {
                    throw new FileNotFoundException(beforePath);
                }
                diffRequestProducers.add(new TextShelveDiffRequestProducer(project, shelvedChange, filePath, file2, patchContext, preloader, commitContext, withLocal));
            }
            catch (IOException e) {
                diffRequestProducers.add(new PatchShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, commitContext));
            }
        }
    }

    @NotNull
    static AppliedTextPatch createAppliedTextPatch(@NotNull TextFilePatch patch) {
        GenericPatchApplier applier = new GenericPatchApplier("", patch.getHunks());
        applier.execute();
        return AppliedTextPatch.create(applier.getAppliedInfo());
    }

    private static abstract class BaseTextShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final ShelvedChange myChange;

        BaseTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath) {
            super(filePath);
            this.myChange = change;
            this.myProject = project;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.myChange.getFileStatus();
        }

        @Override
        @NotNull
        public ShelvedChange getTextChange() {
            return this.myChange;
        }
    }

    private static class TextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ApplyPatchContext myPatchContext;
        @NotNull
        private final PatchesPreloader myPreloader;
        @NotNull
        private final CommitContext myCommitContext;
        private final boolean myWithLocal;

        TextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull VirtualFile file2, @NotNull ApplyPatchContext patchContext, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, boolean withLocal) {
            super(project, change, filePath);
            this.myFile = file2;
            this.myPatchContext = patchContext;
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (this.myFile.getFileType() == UnknownFileType.INSTANCE) {
                return new UnknownFileTypeDiffRequest(this.myFile, this.getName());
            }
            try {
                TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                if (patch.isDeletedFile()) {
                    return this.createDiffRequestForDeleted(patch);
                }
                String path = (String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName());
                CharSequence baseContents = ((BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)this.myProject, BaseRevisionTextPatchEP.class)).provideContent(path, this.myCommitContext);
                ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(this.myProject, this.myFile, this.myPatchContext.getPathBeforeRename(this.myFile), patch, baseContents);
                if (texts.isBaseRevisionLoaded()) {
                    assert (!texts.isAppliedSomehow());
                    return this.createDiffRequestUsingBase(texts);
                }
                return this.createDiffRequestUsingLocal(texts, patch, context, indicator);
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
            }
        }

        @NotNull
        private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch) {
            String leftTitle;
            DiffContent leftContent;
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.CURRENT_VERSION;
            } else {
                leftContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.SHELVED_VERSION;
            }
            EmptyContent rightContent = contentFactory.createEmpty();
            String rightTitle = null;
            return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }

        @NotNull
        private DiffRequest createDiffRequestUsingBase(@NotNull ApplyPatchForBaseRevisionTexts texts) {
            String leftTitle;
            DiffContent leftContent;
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.CURRENT_VERSION;
            } else {
                leftContent = contentFactory.create(this.myProject, (String)ObjectUtils.assertNotNull((Object)texts.getBase()), this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.BASE_VERSION;
            }
            DocumentContent rightContent = contentFactory.create(this.myProject, texts.getPatched(), this.myFile);
            String rightTitle = DiffShelvedChangesActionProvider.SHELVED_VERSION;
            return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }

        private DiffRequest createDiffRequestUsingLocal(@NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull TextFilePatch patch, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            DiffRequest diffRequest;
            DiffRequest diffRequest2 = diffRequest = this.myChange.isConflictingChange(this.myProject) ? PatchDiffRequestFactory.createConflictDiffRequest(this.myProject, this.myFile, patch, DiffShelvedChangesActionProvider.SHELVED_VERSION, texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(this.myProject), this.getName(), context, indicator);
            if (!this.myWithLocal) {
                DiffUtil.addNotification(DiffNotifications.createNotification("Base content not found or not applicable. Showing difference with local version"), (UserDataHolder)diffRequest);
            }
            return diffRequest;
        }
    }

    private static class NewFileTextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final PatchesPreloader myPreloader;
        @NotNull
        private final CommitContext myCommitContext;
        private final boolean myWithLocal;

        NewFileTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, boolean withLocal) {
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            VirtualFile file2 = this.myFilePath.getVirtualFile();
            if (this.myWithLocal && file2 != null) {
                try {
                    TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                    DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                    DiffContent leftContent = contentFactory.create(this.myProject, file2);
                    DocumentContent rightContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), file2);
                    return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, DiffShelvedChangesActionProvider.CURRENT_VERSION, DiffShelvedChangesActionProvider.SHELVED_VERSION);
                }
                catch (VcsException e) {
                    throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
                }
            }
            return PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(this.myProject), this.getName(), context, indicator);
        }
    }

    private static class PatchShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        private final PatchesPreloader myPreloader;
        private final CommitContext myCommitContext;

        PatchShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext) {
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            try {
                TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                AppliedTextPatch appliedTextPatch = DiffShelvedChangesActionProvider.createAppliedTextPatch(patch);
                PatchDiffRequest request = new PatchDiffRequest(appliedTextPatch, this.getName(), VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]));
                DiffUtil.addNotification(DiffNotifications.createNotification("Cannot find local file for '" + this.getFilePath() + "'"), (UserDataHolder)request);
                return request;
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
            }
        }
    }

    private static class BinaryShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelvedBinaryFile myBinaryChange;

        BinaryShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedBinaryFile change, @NotNull FilePath filePath) {
            super(filePath);
            this.myBinaryChange = change;
            this.myProject = project;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            Change change = this.myBinaryChange.createChange(this.myProject);
            return PatchDiffRequestFactory.createDiffRequest(this.myProject, change, this.getName(), context, indicator);
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.myBinaryChange.getFileStatus();
        }

        @Override
        @NotNull
        public ShelvedBinaryFile getBinaryChange() {
            return this.myBinaryChange;
        }
    }

    private static abstract class ShelveDiffRequestProducer
    implements ChangeDiffRequestChain.Producer {
        @NotNull
        protected final FilePath myFilePath;

        ShelveDiffRequestProducer(@NotNull FilePath filePath) {
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return null;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return null;
        }

        @NotNull
        public String getName() {
            return FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            return this.myFilePath;
        }
    }

    static class PatchesPreloader {
        private final Project myProject;
        private final SoftHardCacheMap<String, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        PatchesPreloader(Project project) {
            this.myProject = project;
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, @Nullable CommitContext commitContext) throws VcsException {
            PatchInfo patchInfo;
            String patchPath = shelvedChange.getPatchPath();
            if (this.getInfoFromCache(patchPath) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath, commitContext);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    return textFilePatch;
                }
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }

        private PatchInfo getInfoFromCache(@NotNull String patchPath) {
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = this.myFilePatchesMap.get(patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull String patchPath, @Nullable CommitContext commitContext) throws VcsException {
            try {
                this.myLock.writeLock().lock();
                this.myFilePatchesMap.put(patchPath, new PatchInfo(ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext), new File(patchPath).lastModified()));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull String patchPath) {
            PatchInfo patchInfo = this.getInfoFromCache(patchPath);
            long lastModified = new File(patchPath).lastModified();
            return patchInfo != null && lastModified != patchInfo.myLoadedTimeStamp;
        }

        private static class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;

            PatchInfo(@NotNull List<TextFilePatch> patches2, long loadedTimeStamp) {
                this.myTextFilePatches = patches2;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }
        }
    }

    private static class ChangeDiffRequestComparator
    implements Comparator<DiffRequestProducer> {
        private static final ChangeDiffRequestComparator ourInstance = new ChangeDiffRequestComparator();

        private ChangeDiffRequestComparator() {
        }

        public static ChangeDiffRequestComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(DiffRequestProducer o1, DiffRequestProducer o2) {
            return FilePathsHelper.convertPath((String)o1.getName()).compareTo(FilePathsHelper.convertPath((String)o2.getName()));
        }
    }
}

