/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryFilePatch
extends FilePatch {
    private final ShelvedBinaryFile myShelvedBinaryFile;

    public ShelvedBinaryFilePatch(@NotNull ShelvedBinaryFile shelvedBinaryFile) {
        this.myShelvedBinaryFile = shelvedBinaryFile;
        this.setBeforeName(this.myShelvedBinaryFile.BEFORE_PATH);
        this.setAfterName(this.myShelvedBinaryFile.AFTER_PATH);
    }

    public static ShelvedBinaryFilePatch patchCopy(@NotNull ShelvedBinaryFilePatch patch) {
        return new ShelvedBinaryFilePatch(patch.getShelvedBinaryFile());
    }

    @Nullable
    public String getBeforeFileName() {
        return ShelvedBinaryFilePatch.getFileName(this.myShelvedBinaryFile.BEFORE_PATH);
    }

    @Nullable
    public String getAfterFileName() {
        return ShelvedBinaryFilePatch.getFileName(this.myShelvedBinaryFile.AFTER_PATH);
    }

    @Nullable
    private static String getFileName(String filePath) {
        return filePath != null ? PathUtil.getFileName((String)filePath) : null;
    }

    public boolean isNewFile() {
        return this.myShelvedBinaryFile.BEFORE_PATH == null;
    }

    public boolean isDeletedFile() {
        return this.myShelvedBinaryFile.AFTER_PATH == null;
    }

    @NotNull
    public ShelvedBinaryFile getShelvedBinaryFile() {
        return this.myShelvedBinaryFile;
    }
}

