/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChange {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelvedChange");
    private final String myPatchPath;
    private final String myBeforePath;
    private final String myAfterPath;
    private final FileStatus myFileStatus;
    private Change myChange;

    public ShelvedChange(String patchPath, String beforePath, String afterPath, FileStatus fileStatus) {
        this.myPatchPath = patchPath;
        this.myBeforePath = beforePath;
        this.myAfterPath = Comparing.equal((String)beforePath, (String)afterPath) ? beforePath : afterPath;
        this.myFileStatus = fileStatus;
    }

    public boolean isConflictingChange(Project project) {
        block3: {
            ContentRevision afterRevision = this.getChange(project).getAfterRevision();
            if (afterRevision == null) {
                return false;
            }
            try {
                afterRevision.getContent();
            }
            catch (VcsException e) {
                if (!(e.getCause() instanceof ApplyPatchException)) break block3;
                return true;
            }
        }
        return false;
    }

    public String getBeforePath() {
        return this.myBeforePath;
    }

    public String getAfterPath() {
        return this.myAfterPath;
    }

    public FileStatus getFileStatus() {
        return this.myFileStatus;
    }

    @NotNull
    public Change getChange(@NotNull Project project) {
        if (this.myChange == null) {
            File baseDir = new File(project.getBaseDir().getPath());
            File file2 = ShelvedChange.getAbsolutePath(baseDir, this.myBeforePath);
            FilePath beforePath = VcsUtil.getFilePath((File)file2, (boolean)false);
            CurrentContentRevision beforeRevision = null;
            if (this.myFileStatus != FileStatus.ADDED) {
                beforeRevision = new CurrentContentRevision(beforePath){

                    @NotNull
                    public VcsRevisionNumber getRevisionNumber() {
                        return new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                    }
                };
            }
            PatchedContentRevision afterRevision = null;
            if (this.myFileStatus != FileStatus.DELETED) {
                FilePath afterPath = VcsUtil.getFilePath((File)ShelvedChange.getAbsolutePath(baseDir, this.myAfterPath), (boolean)false);
                afterRevision = new PatchedContentRevision(project, beforePath, afterPath);
            }
            this.myChange = new Change((ContentRevision)beforeRevision, afterRevision, this.myFileStatus);
        }
        return this.myChange;
    }

    private static File getAbsolutePath(File baseDir, String relativePath) {
        File file2;
        try {
            file2 = new File(baseDir, relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            file2 = new File(baseDir, relativePath);
        }
        return file2;
    }

    @Nullable
    public TextFilePatch loadFilePatch(Project project, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(project, this.myPatchPath, commitContext);
        for (TextFilePatch patch : filePatches) {
            if (!this.myBeforePath.equals(patch.getBeforeName())) continue;
            return patch;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShelvedChange)) {
            return false;
        }
        ShelvedChange that = (ShelvedChange)o;
        if (!Objects.equals(this.myAfterPath, that.myAfterPath)) {
            return false;
        }
        if (!Objects.equals(this.myBeforePath, that.myBeforePath)) {
            return false;
        }
        if (!Objects.equals(this.myFileStatus, that.myFileStatus)) {
            return false;
        }
        return Objects.equals(this.myPatchPath, that.myPatchPath);
    }

    public int hashCode() {
        return Objects.hash(this.myPatchPath, this.myBeforePath, this.myAfterPath, this.myFileStatus);
    }

    public String getPatchPath() {
        return this.myPatchPath;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.myBeforePath == null ? this.myAfterPath : this.myBeforePath));
    }

    private class PatchedContentRevision
    implements ContentRevision {
        private final Project myProject;
        private final FilePath myBeforeFilePath;
        private final FilePath myAfterFilePath;

        PatchedContentRevision(Project project, FilePath beforeFilePath, FilePath afterFilePath) {
            this.myProject = project;
            this.myBeforeFilePath = beforeFilePath;
            this.myAfterFilePath = afterFilePath;
        }

        @Nullable
        public String getContent() throws VcsException {
            try {
                return this.loadContent();
            }
            catch (Exception e) {
                throw new VcsException((Throwable)e);
            }
        }

        @Nullable
        private String loadContent() throws IOException, PatchSyntaxException, ApplyPatchException {
            TextFilePatch patch = ShelvedChange.this.loadFilePatch(this.myProject, null);
            if (patch != null) {
                return this.loadContent(patch);
            }
            return null;
        }

        private String loadContent(TextFilePatch patch) throws ApplyPatchException {
            if (patch.isNewFile()) {
                return patch.getSingleHunkPatchText();
            }
            if (patch.isDeletedFile()) {
                return null;
            }
            GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(this.getBaseContent(), patch.getHunks());
            if (appliedPatch != null) {
                return appliedPatch.patchedText;
            }
            throw new ApplyPatchException("Apply patch conflict");
        }

        private String getBaseContent() {
            return (String)ReadAction.compute(() -> {
                Document doc = FileDocumentManager.getInstance().getDocument(this.myBeforeFilePath.getVirtualFile());
                return doc.getText();
            });
        }

        @NotNull
        public FilePath getFile() {
            return this.myAfterFilePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return new TextRevisionNumber(VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]));
        }
    }
}

