/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShelvedWrapper {
    @Nullable
    private final ShelvedChange myShelvedChange;
    @Nullable
    private final ShelvedBinaryFile myBinaryFile;

    ShelvedWrapper(@NotNull ShelvedChange shelvedChange) {
        this.myShelvedChange = shelvedChange;
        this.myBinaryFile = null;
    }

    ShelvedWrapper(@NotNull ShelvedBinaryFile binaryFile) {
        this.myShelvedChange = null;
        this.myBinaryFile = binaryFile;
    }

    @Nullable
    public ShelvedChange getShelvedChange() {
        return this.myShelvedChange;
    }

    @Nullable
    public ShelvedBinaryFile getBinaryFile() {
        return this.myBinaryFile;
    }

    public String getRequestName() {
        return FileUtil.toSystemDependentName((String)((String)ObjectUtils.chooseNotNull((Object)this.getAfterPath(), (Object)this.getBeforePath())));
    }

    String getBeforePath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getBeforePath() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).BEFORE_PATH;
    }

    String getAfterPath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getAfterPath() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).AFTER_PATH;
    }

    FileStatus getFileStatus() {
        return this.myShelvedChange != null ? this.myShelvedChange.getFileStatus() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).getFileStatus();
    }

    Change getChange(@NotNull Project project) {
        return this.myShelvedChange != null ? this.myShelvedChange.getChange(project) : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).createChange(project);
    }

    @Nullable
    public VirtualFile getBeforeVFUnderProject(@NotNull Project project) {
        if (this.getBeforePath() == null || project.getBaseDir() == null) {
            return null;
        }
        File baseDir = new File(project.getBaseDir().getPath());
        File file2 = new File(baseDir, this.getBeforePath());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }
}

