/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.UnshelvePatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)ObjectUtils.assertNotNull((Object)UnshelveWithDialogAction.getEventProject((AnActionEvent)e));
        DataContext dataContext = e.getDataContext();
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dataContext);
        if (changeLists.isEmpty()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (changeLists.size() > 1) {
            UnshelveWithDialogAction.unshelveMultipleShelveChangeLists(project, changeLists, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext), ShelvedChangesViewManager.getShelveChanges(dataContext));
        } else {
            ShelvedChangeList changeList = changeLists.get(0);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(changeList.PATH));
            if (virtualFile == null) {
                VcsBalloonProblemNotifier.showOverChangesView(project, "Can not find path file", MessageType.ERROR, new NamedRunnable[0]);
                return;
            }
            List binaryShelvedPatches = ContainerUtil.map(changeList.getBinaryFiles(), ShelvedBinaryFilePatch::new);
            MyUnshelveDialog dialog2 = new MyUnshelveDialog(project, virtualFile, changeList, binaryShelvedPatches, (Change[])e.getData(VcsDataKeys.CHANGES));
            dialog2.setHelpId("reference.dialogs.vcs.unshelve");
            dialog2.show();
        }
    }

    private static void unshelveMultipleShelveChangeLists(final @NotNull Project project, @NotNull List<? extends ShelvedChangeList> changeLists, @NotNull List<? extends ShelvedBinaryFile> binaryFiles, @NotNull List<? extends ShelvedChange> changes2) {
        String suggestedName = changeLists.get((int)0).DESCRIPTION;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ChangeListChooser chooser = new ChangeListChooser(project, changeListManager.getChangeListsCopy(), (ChangeList)changeListManager.getDefaultChangeList(), VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0]), suggestedName){

            protected JComponent createDoNotAskCheckbox() {
                return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(project);
            }
        };
        if (!chooser.showAndGet()) {
            return;
        }
        ShelveChangesManager.getInstance(project).unshelveSilentlyAsynchronously(project, changeLists, changes2, binaryFiles, chooser.getSelectedList());
    }

    private static boolean hasNotAllSelectedChanges(@NotNull Project project, @NotNull ShelvedChangeList list2, @Nullable Change[] changes2) {
        return changes2 != null && list2.getChanges(project).size() + list2.getBinaryFiles().size() != changes2.length;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(UnshelveWithDialogAction.getEventProject((AnActionEvent)e) != null && !ShelvedChangesViewManager.getShelvedLists(e.getDataContext()).isEmpty());
    }

    @NotNull
    private static JCheckBox createRemoveFilesStrategyCheckbox(@NotNull Project project) {
        final JCheckBox removeOptionCheckBox = new JCheckBox("Remove successfully applied files from the shelf");
        removeOptionCheckBox.setMnemonic(82);
        final ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project);
        removeOptionCheckBox.setSelected(shelveChangesManager.isRemoveFilesFromShelf());
        removeOptionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shelveChangesManager.setRemoveFilesFromShelf(removeOptionCheckBox.isSelected());
            }
        });
        return removeOptionCheckBox;
    }

    private static class MyUnshelveDialog
    extends ApplyPatchDifferentiatedDialog {
        MyUnshelveDialog(@NotNull Project project, @NotNull VirtualFile patchFile, @NotNull ShelvedChangeList changeList, @NotNull List<? extends ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Change[] preselectedChanges) {
            super(project, new UnshelvePatchDefaultExecutor(project, changeList), Collections.emptyList(), ApplyPatchMode.UNSHELVE, patchFile, null, ChangeListUtil.getPredefinedChangeList(changeList, ChangeListManager.getInstance((Project)project)), binaryShelvedPatches, UnshelveWithDialogAction.hasNotAllSelectedChanges(project, changeList, preselectedChanges) ? ContainerUtil.newArrayList((Object[])preselectedChanges) : null, ChangeListUtil.getChangeListNameForUnshelve(changeList), true);
            this.setOKButtonText(VcsBundle.getString((String)"unshelve.changes.action"));
        }

        @Nullable
        protected JComponent createDoNotAskCheckbox() {
            return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(this.myProject);
        }
    }
}

