/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestChainBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestChain
extends DiffRequestChainBase
implements GoToChangePopupBuilder.Chain {
    private static final Logger LOG = Logger.getInstance(ChangeDiffRequestChain.class);
    @NotNull
    private final List<? extends Producer> myProducers;

    public ChangeDiffRequestChain(@NotNull List<? extends Producer> producers, int index) {
        super(index);
        if (ContainerUtil.exists(producers, Objects::isNull)) {
            producers = ContainerUtil.skipNulls(producers);
            LOG.error("Producers must not be null");
        }
        this.myProducers = producers;
    }

    @NotNull
    public List<? extends Producer> getRequests() {
        return this.myProducers;
    }

    @Override
    @NotNull
    public AnAction createGoToChangeAction(@NotNull Consumer<? super Integer> onSelected) {
        return ChangeDiffRequestChain.createGoToChangeAction(this, onSelected);
    }

    @NotNull
    public static AnAction createGoToChangeAction(final @NotNull DiffRequestChain chain, final @NotNull Consumer<? super Integer> onSelected) {
        return new ChangeGoToChangePopupAction<DiffRequestChain>(chain, (Object)chain.getIndex()){

            @Override
            @NotNull
            protected DefaultTreeModel buildTreeModel(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
                MultiMap groups = new MultiMap();
                List producers = chain.getRequests();
                for (int i = 0; i < producers.size(); ++i) {
                    Producer producer = (Producer)ObjectUtils.tryCast(producers.get(i), Producer.class);
                    if (producer == null) continue;
                    FilePath filePath = producer.getFilePath();
                    FileStatus fileStatus = producer.getFileStatus();
                    Object tag = producer.getPopupTag();
                    groups.putValue(tag, (Object)new GenericChangesBrowserNode(filePath, fileStatus, i));
                }
                MyTreeModelBuilder builder2 = new MyTreeModelBuilder(project, grouping2);
                for (Object tag : groups.keySet()) {
                    builder2.setGenericNodes(groups.get(tag), tag);
                }
                return builder2.build();
            }

            @Override
            protected void onSelected(@Nullable Object object) {
                onSelected.consume((Object)((Integer)object));
            }
        };
    }

    private static class GenericChangesBrowserNode
    extends ChangesBrowserNode<Object>
    implements Comparable<GenericChangesBrowserNode> {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final FileStatus myFileStatus;

        protected GenericChangesBrowserNode(@NotNull FilePath filePath, @NotNull FileStatus fileStatus, @NotNull Object userObject) {
            super(userObject);
            this.myFilePath = filePath;
            this.myFileStatus = fileStatus;
        }

        @Override
        protected boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        protected boolean isDirectory() {
            return this.myFilePath.isDirectory();
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            renderer2.appendFileName(this.myFilePath.getVirtualFile(), this.myFilePath.getName(), this.myFileStatus.getColor());
            if (renderer2.isShowFlatten()) {
                this.appendParentPath(renderer2, this.myFilePath.getParentPath());
            }
            if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
                this.appendCount(renderer2);
            }
            renderer2.setIcon(this.myFilePath.getFileType(), this.myFilePath.isDirectory() || !this.isLeaf());
        }

        @Override
        public String getTextPresentation() {
            return this.myFilePath.getName();
        }

        @Override
        public String toString() {
            return FileUtil.toSystemDependentName((String)this.myFilePath.getPath());
        }

        @Override
        public int compareTo(@NotNull GenericChangesBrowserNode o) {
            return this.myFilePath.getPath().compareToIgnoreCase(o.myFilePath.getPath());
        }
    }

    private static class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
            super(project, grouping2);
        }

        public void setGenericNodes(@NotNull Collection<GenericChangesBrowserNode> nodes, @Nullable Object tag) {
            ChangesBrowserNode parentNode = this.createTagNode(tag);
            for (GenericChangesBrowserNode node : ContainerUtil.sorted(nodes, Comparator.comparing(data -> ((GenericChangesBrowserNode)data).myFilePath, PATH_COMPARATOR))) {
                this.insertChangeNode(node.myFilePath, parentNode, node);
            }
        }
    }

    public static interface Producer
    extends DiffRequestProducer {
        @NotNull
        public FilePath getFilePath();

        @NotNull
        public FileStatus getFileStatus();

        @Nullable
        default public Object getPopupTag() {
            return null;
        }
    }
}

