/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.CommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Function;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListViewerDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ChangeListViewerDialog.class);
    private final JBLoadingPanel myLoadingPanel;
    private final CommittedChangeListPanel myChangesPanel;

    public ChangeListViewerDialog(@NotNull Project project) {
        this(project, null, (CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptyList()), null);
    }

    public ChangeListViewerDialog(@NotNull Project project, @NotNull CommittedChangeList changeList, @Nullable VirtualFile toSelect2) {
        this(project, null, changeList, toSelect2);
    }

    public ChangeListViewerDialog(@NotNull Project project, @NotNull Collection<Change> changes2) {
        this(null, project, changes2);
    }

    public ChangeListViewerDialog(@Nullable Component parent, @NotNull Project project, @NotNull Collection<Change> changes2) {
        this(project, parent, (CommittedChangeList)CommittedChangeListPanel.createChangeList(changes2), null);
        this.myChangesPanel.setShowCommitMessage(false);
    }

    private ChangeListViewerDialog(@NotNull Project project, @Nullable Component parentComponent, @NotNull CommittedChangeList changeList, @Nullable VirtualFile toSelect2) {
        super(project, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myChangesPanel = new CommittedChangeListPanel(project);
        this.myChangesPanel.setChangeList(changeList);
        this.myChangesPanel.getChangesBrowser().getViewer().selectFile(toSelect2);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myLoadingPanel.add((Component)this.myChangesPanel, (Object)"Center");
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
    }

    public void markChangesInAir(boolean inAir) {
        this.myChangesPanel.getChangesBrowser().setUseCase(inAir ? CommittedChangesBrowserUseCase.IN_AIR : null);
    }

    public void loadChangesInBackground(@NotNull ThrowableComputable<? extends ChangelistData, ? extends VcsException> computable) {
        StatusText emptyText = this.myChangesPanel.getChangesBrowser().getViewer().getEmptyText();
        emptyText.setText("");
        BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            try {
                ChangelistData result2 = (ChangelistData)computable.compute();
                return () -> {
                    this.myLoadingPanel.stopLoading();
                    this.myChangesPanel.setChangeList(result2.changeList);
                    this.myChangesPanel.getChangesBrowser().getViewer().selectFile(result2.toSelect);
                    emptyText.setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
                };
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return () -> {
                    this.myLoadingPanel.stopLoading();
                    this.myChangesPanel.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptySet()));
                    emptyText.setText(e.getMessage(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                };
            }
        }), () -> this.myLoadingPanel.startLoading());
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangeListViewerDialog";
    }

    public JComponent createCenterPanel() {
        return this.myLoadingPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        return new Action[]{cancelAction};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangesPanel.getPreferredFocusedComponent();
    }

    public void setDescription(@Nullable String description) {
        this.myChangesPanel.setDescription(description);
    }

    public static class ChangelistData {
        @NotNull
        public final CommittedChangeList changeList;
        @Nullable
        public final FilePath toSelect;

        public ChangelistData(@NotNull CommittedChangeList changeList, @Nullable FilePath toSelect2) {
            this.changeList = changeList;
            this.toSelect = toSelect2;
        }
    }
}

