/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserChangeNode
extends ChangesBrowserNode<Change>
implements TreeLinkMouseListener.HaveTooltip {
    @Nullable
    private final Project myProject;
    @Nullable
    private final ChangeNodeDecorator myDecorator;

    protected ChangesBrowserChangeNode(@Nullable Project project, @NotNull Change userObject, @Nullable ChangeNodeDecorator decorator) {
        super(userObject);
        this.myProject = project;
        this.myDecorator = decorator;
    }

    @Override
    protected boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        Icon additionalIcon;
        Change change = (Change)this.getUserObject();
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        VirtualFile file2 = filePath.getVirtualFile();
        if (this.myDecorator != null) {
            this.myDecorator.preDecorate(change, renderer2, renderer2.isShowFlatten());
        }
        renderer2.appendFileName(file2, filePath.getName(), change.getFileStatus().getColor());
        String originText = change.getOriginText(this.myProject);
        if (originText != null) {
            renderer2.append(FontUtil.spaceAndThinSpace() + originText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (renderer2.isShowFlatten()) {
            this.appendParentPath(renderer2, filePath.getParentPath());
        }
        this.appendSwitched(renderer2, file2);
        if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer2);
        }
        if ((additionalIcon = change.getAdditionalIcon()) != null) {
            renderer2.setIcon(additionalIcon);
        } else {
            renderer2.setIcon(filePath.getFileType(), filePath.isDirectory() || !this.isLeaf());
        }
        if (this.myDecorator != null) {
            this.myDecorator.decorate(change, (SimpleColoredComponent)renderer2, renderer2.isShowFlatten());
        }
    }

    private void appendSwitched(@NotNull ChangesBrowserNodeRenderer renderer2, @Nullable VirtualFile file2) {
        String branch;
        if (file2 != null && this.myProject != null && !this.myProject.isDefault() && (branch = ChangeListManager.getInstance((Project)this.myProject).getSwitchedBranch(file2)) != null) {
            renderer2.append(FontUtil.spaceAndThinSpace() + "[switched to " + branch + "]", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    public String getTooltip() {
        return ((Change)this.getUserObject()).getDescription();
    }

    @Override
    public String getTextPresentation() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getName();
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getPath());
    }

    @Override
    public int getSortWeight() {
        return 7;
    }

    @Override
    public int compareUserObjects(Change o2) {
        return ChangesComparator.getInstance(true).compare((Change)this.getUserObject(), o2);
    }
}

