/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFileNode
extends ChangesBrowserNode<VirtualFile>
implements Comparable<ChangesBrowserFileNode> {
    @Nullable
    private final Project myProject;
    private final String myName;

    public ChangesBrowserFileNode(@Nullable Project project, @NotNull VirtualFile userObject) {
        super(userObject);
        this.myName = StringUtil.toLowerCase((String)userObject.getName());
        this.myProject = project;
    }

    @Override
    protected boolean isFile() {
        return !((VirtualFile)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        if (((VirtualFile)this.getUserObject()).isDirectory()) {
            return this.isLeaf() || this.getFileStatus() != FileStatus.NOT_CHANGED;
        }
        return false;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        VirtualFile file2 = (VirtualFile)this.getUserObject();
        FileStatus fileStatus = this.getFileStatus();
        renderer2.appendFileName(file2, file2.getName(), fileStatus.getColor());
        if (renderer2.isShowFlatten() && file2.isValid()) {
            this.appendParentPath(renderer2, file2.getParent());
        }
        if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer2);
        }
        renderer2.setIcon(file2.getFileType(), file2.isDirectory());
    }

    @Override
    public String getTextPresentation() {
        return ((VirtualFile)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return ((VirtualFile)this.getUserObject()).getPresentableUrl();
    }

    @Override
    public int getSortWeight() {
        return 8;
    }

    @Override
    public int compareTo(ChangesBrowserFileNode o) {
        return this.myName.compareTo(o.myName);
    }

    @Override
    public int compareUserObjects(VirtualFile o2) {
        return ((VirtualFile)this.getUserObject()).getName().compareToIgnoreCase(o2.getName());
    }

    @NotNull
    private FileStatus getFileStatus() {
        if (this.myProject == null) {
            return FileStatus.NOT_CHANGED;
        }
        return ChangeListManager.getInstance((Project)this.myProject).getStatus((VirtualFile)this.getUserObject());
    }
}

