/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFilePathNode
extends ChangesBrowserNode<FilePath> {
    public ChangesBrowserFilePathNode(FilePath userObject) {
        super(userObject);
    }

    @Override
    protected boolean isFile() {
        return !((FilePath)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((FilePath)this.getUserObject()).isDirectory() && this.isLeaf();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        FilePath path = (FilePath)this.userObject;
        if (path.isDirectory() || !this.isLeaf()) {
            renderer2.append(this.getRelativePath(path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (!this.isLeaf()) {
                this.appendCount(renderer2);
            }
        } else if (renderer2.isShowFlatten()) {
            renderer2.append(path.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.appendParentPath(renderer2, path.getParentPath());
        } else {
            renderer2.append(this.getRelativePath(path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        renderer2.setIcon(path.getFileType(), path.isDirectory() || !this.isLeaf());
    }

    @NotNull
    protected String getRelativePath(FilePath path) {
        return ChangesBrowserFilePathNode.getRelativePath(ChangesBrowserFilePathNode.safeCastToFilePath((ChangesBrowserNode)this.getParent()), path);
    }

    @Override
    public String getTextPresentation() {
        return this.getRelativePath((FilePath)this.getUserObject());
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)((FilePath)this.getUserObject()).getPath());
    }

    @Nullable
    public static FilePath safeCastToFilePath(ChangesBrowserNode node) {
        if (node instanceof ChangesBrowserModuleNode) {
            return ((ChangesBrowserModuleNode)node).getModuleRoot();
        }
        Object o = node.getUserObject();
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof Change) {
            return ChangesUtil.getAfterPath((Change)((Change)o));
        }
        return null;
    }

    @NotNull
    public static String getRelativePath(@Nullable FilePath parent, @NotNull FilePath child2) {
        boolean isLocal = !child2.isNonLocal();
        boolean caseSensitive = isLocal && SystemInfoRt.isFileSystemCaseSensitive;
        String result2 = parent != null ? FileUtil.getRelativePath((String)parent.getPath(), (String)child2.getPath(), (char)'/', (boolean)caseSensitive) : null;
        result2 = result2 == null ? child2.getPath() : result2;
        return isLocal ? FileUtil.toSystemDependentName((String)result2) : result2;
    }

    @Override
    public int getSortWeight() {
        if (((FilePath)this.userObject).isDirectory()) {
            return 5;
        }
        return 6;
    }

    @Override
    public int compareUserObjects(FilePath o2) {
        return ((FilePath)this.getUserObject()).getPath().compareToIgnoreCase(o2.getPath());
    }
}

