/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserIgnoredFilesNode
extends ChangesBrowserSpecificFilesNode {
    private final boolean myUpdatingMode;

    protected ChangesBrowserIgnoredFilesNode(Project project, @NotNull List<VirtualFile> files2, boolean updatingMode) {
        super(IGNORED_FILES_TAG, files2, () -> {
            if (!project.isDisposed()) {
                new IgnoredViewDialog(project).show();
            }
        });
        this.myUpdatingMode = updatingMode;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        super.render(renderer2, selected, expanded, hasFocus);
        if (this.myUpdatingMode) {
            this.appendUpdatingState(renderer2);
        }
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return dragBean.getUnversionedFiles().size() > 0;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
        IgnoreUnversionedDialog.ignoreSelectedFiles(dragOwner.getProject(), dragBean.getUnversionedFiles());
    }

    @Override
    public int getSortWeight() {
        return 11;
    }
}

