/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserLocallyDeletedNode
extends ChangesBrowserNode<LocallyDeletedChange>
implements TreeLinkMouseListener.HaveTooltip {
    public ChangesBrowserLocallyDeletedNode(@NotNull LocallyDeletedChange userObject) {
        super(userObject);
    }

    @Override
    protected boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((LocallyDeletedChange)this.getUserObject()).getPath().isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        Icon additionalIcon;
        FilePath filePath = ((LocallyDeletedChange)this.getUserObject()).getPath();
        renderer2.appendFileName(filePath.getVirtualFile(), filePath.getName(), FileStatus.NOT_CHANGED.getColor());
        if (renderer2.isShowFlatten()) {
            this.appendParentPath(renderer2, filePath.getParentPath());
        }
        if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer2);
        }
        if ((additionalIcon = ((LocallyDeletedChange)this.getUserObject()).getAddIcon()) != null) {
            renderer2.setIcon(additionalIcon);
        } else {
            renderer2.setIcon(filePath.getFileType(), filePath.isDirectory() || !this.isLeaf());
        }
    }

    @Override
    @Nullable
    public String getTooltip() {
        return ((LocallyDeletedChange)this.getUserObject()).getDescription();
    }
}

