/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserModuleNode
extends ChangesBrowserNode<Module> {
    @NotNull
    private final FilePath myModuleRoot;

    protected ChangesBrowserModuleNode(Module userObject) {
        super(userObject);
        this.myModuleRoot = ChangesBrowserModuleNode.getModuleRootFilePath(userObject);
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        Module module = (Module)this.userObject;
        renderer2.append(module.isDisposed() ? "" : module.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer2);
        this.appendParentPath(renderer2, this.myModuleRoot);
        if (module.isDisposed()) {
            renderer2.setIcon(ModuleType.EMPTY.getIcon());
        } else {
            renderer2.setIcon(ModuleType.get((Module)module).getIcon());
        }
    }

    @NotNull
    public FilePath getModuleRoot() {
        return this.myModuleRoot;
    }

    @Override
    public String getTextPresentation() {
        return ((Module)this.getUserObject()).getName();
    }

    @Override
    public int getSortWeight() {
        return 4;
    }

    @Override
    public int compareUserObjects(Module o2) {
        return ((Module)this.getUserObject()).getName().compareToIgnoreCase(o2.getName());
    }

    @NotNull
    private static FilePath getModuleRootFilePath(Module module) {
        return (FilePath)ReadAction.compute(() -> {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length == 1) {
                return VcsUtil.getFilePath((VirtualFile)roots[0]);
            }
            return VcsUtil.getFilePath((String)ModuleUtilCore.getModuleDirPath((Module)module));
        });
    }
}

