/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesFileNameDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserNodeRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final BooleanGetter myShowFlatten;
    @Nullable
    private final Project myProject;
    @Nullable
    private final IssueLinkRenderer myIssueLinkRenderer;
    private final boolean myHighlightProblems;
    @Nullable
    private JBInsets myBackgroundInsets;

    public ChangesBrowserNodeRenderer(@Nullable Project project, @NotNull BooleanGetter showFlattenGetter, boolean highlightProblems) {
        this.myShowFlatten = showFlattenGetter;
        this.myProject = project;
        this.myHighlightProblems = highlightProblems;
        this.myIssueLinkRenderer = project != null ? new IssueLinkRenderer(project, (SimpleColoredComponent)this) : null;
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten.get();
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        ChangesBrowserNode node = (ChangesBrowserNode)value;
        node.render(this, selected, expanded, hasFocus);
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
    }

    protected void appendFileName(@Nullable VirtualFile vFile, @NotNull String fileName2, Color color) {
        ChangesFileNameDecorator decorator;
        ChangesFileNameDecorator changesFileNameDecorator = decorator = this.myProject != null && !this.myProject.isDefault() ? ChangesFileNameDecorator.getInstance(this.myProject) : null;
        if (decorator != null) {
            decorator.appendFileName(this, vFile, fileName2, color, this.myHighlightProblems);
        } else {
            this.append(fileName2, new SimpleTextAttributes(0, color));
        }
    }

    public void clear() {
        this.setBackgroundInsets(null);
        this.setToolTipText(null);
        super.clear();
    }

    protected void doPaintFragmentBackground(@NotNull Graphics2D g, int index, @NotNull Color bgColor, int x, int y, int width, int height) {
        if (this.myBackgroundInsets != null) {
            g.setColor(bgColor);
            g.fillRect(x + this.myBackgroundInsets.left, y + this.myBackgroundInsets.top, width - this.myBackgroundInsets.width(), height - this.myBackgroundInsets.height());
        } else {
            super.doPaintFragmentBackground(g, index, bgColor, x, y, width, height);
        }
    }

    public void appendTextWithIssueLinks(@NotNull String text, @NotNull SimpleTextAttributes baseStyle2) {
        if (this.myIssueLinkRenderer != null) {
            this.myIssueLinkRenderer.appendTextWithLinks(text, baseStyle2);
        } else {
            this.append(text, baseStyle2);
        }
    }

    public void setIcon(@NotNull FileType fileType, boolean isDirectory) {
        Icon icon = isDirectory ? PlatformIcons.FOLDER_ICON : fileType.getIcon();
        this.setIcon(icon);
    }

    public void setBackgroundInsets(@Nullable JBInsets backgroundInsets) {
        this.myBackgroundInsets = backgroundInsets;
    }

    public boolean isShowingLocalChanges() {
        return this.myHighlightProblems;
    }
}

