/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserSpecificFilesNode
extends ChangesBrowserNode<Object> {
    protected final boolean myIsMany;
    @NotNull
    protected final Runnable myDialogShower;
    private final int myManyFileCount;
    private final int myManyDirectoryCount;

    protected ChangesBrowserSpecificFilesNode(Object userObject, @NotNull List<VirtualFile> files2, @NotNull Runnable shower) {
        super(userObject);
        this.myManyDirectoryCount = ContainerUtil.count(files2, it -> it.isDirectory());
        this.myManyFileCount = files2.size() - this.myManyDirectoryCount;
        this.myIsMany = files2.size() > Registry.intValue((String)"vcs.unversioned.files.max.intree", (int)1000);
        this.myDialogShower = shower;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        super.render(renderer2, selected, expanded, hasFocus);
        if (this.isManyFiles()) {
            renderer2.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer2.append("browse", SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getFileCount() {
        return this.myIsMany ? this.myManyFileCount : super.getFileCount();
    }

    @Override
    public int getDirectoryCount() {
        return this.myIsMany ? this.myManyDirectoryCount : super.getDirectoryCount();
    }

    public boolean isManyFiles() {
        return this.myIsMany;
    }
}

