/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesDnDSupport
implements DnDDropHandler,
DnDTargetChecker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeListManagerImpl myChangeListManager;
    @NotNull
    private final Tree myTree;

    public static void install(@NotNull Project project, @NotNull Tree tree) {
        new ChangesDnDSupport(project, tree).install();
    }

    private ChangesDnDSupport(@NotNull Project project, @NotNull Tree tree) {
        this.myProject = project;
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        this.myTree = tree;
    }

    private void install() {
        DnDSupport.createBuilder((JComponent)this.myTree).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setDisposableParent((Disposable)(this.myTree instanceof Disposable ? (Disposable)this.myTree : this.myProject)).install();
    }

    @NotNull
    private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
        String imageText = VcsBundle.message((String)"changes.view.dnd.label", (Object[])new Object[]{this.getSelectionCount()});
        Image image = (Image)DnDAwareTree.getDragImage(this.myTree, imageText, null).getFirst();
        return new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
    }

    @Nullable
    private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        DnDDragStartBean result2 = null;
        if (info.isMove()) {
            Change[] changes2 = (Change[])ChangesListView.getChanges(this.myProject, this.myTree.getSelectionPaths()).toArray(Change[]::new);
            List<VirtualFile> unversionedFiles = ChangesListView.getVirtualFiles(this.myTree.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG).collect(Collectors.toList());
            List<VirtualFile> ignoredFiles = ChangesListView.getVirtualFiles(this.myTree.getSelectionPaths(), ChangesBrowserNode.IGNORED_FILES_TAG).collect(Collectors.toList());
            if (changes2.length > 0 || !unversionedFiles.isEmpty() || !ignoredFiles.isEmpty()) {
                result2 = new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)this.myTree, changes2, unversionedFiles, ignoredFiles));
            }
        }
        return result2;
    }

    public boolean update(DnDEvent aEvent) {
        aEvent.hideHighlighter();
        aEvent.setDropPossible(false, "");
        Object attached = aEvent.getAttachedObject();
        ChangesBrowserNode dropNode = ChangesViewManager.getDropRootNode(this.myTree, aEvent);
        if (attached instanceof ChangeListDragBean) {
            ChangeListDragBean dragBean = (ChangeListDragBean)attached;
            dragBean.setTargetNode(dropNode);
            if (dragBean.getSourceComponent() != this.myTree || dropNode == null || !dropNode.canAcceptDrop(dragBean)) {
                return true;
            }
        } else if (attached instanceof ShelvedChangeListDragBean) {
            if (dropNode != null && !(dropNode instanceof ChangesBrowserChangeListNode)) {
                return true;
            }
        } else {
            return true;
        }
        if (dropNode != null) {
            this.highlightDropNode(aEvent, dropNode);
        }
        aEvent.setDropPossible(true);
        return false;
    }

    private void highlightDropNode(@NotNull DnDEvent aEvent, @NotNull ChangesBrowserNode dropNode) {
        Rectangle tableCellRect = this.myTree.getPathBounds(new TreePath(dropNode.getPath()));
        if (this.fitsInBounds(tableCellRect)) {
            aEvent.setHighlighting(new RelativeRectangle((Component)this.myTree, tableCellRect), 1);
        }
    }

    public void drop(DnDEvent aEvent) {
        ChangeListDragBean dragBean;
        ChangesBrowserNode changesBrowserNode;
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ShelvedChangeListDragBean) {
            ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attached, ChangesViewManager.getDropRootNode(this.myTree, aEvent), !ChangesDnDSupport.isCopyAction(aEvent));
        } else if (attached instanceof ChangeListDragBean && (changesBrowserNode = (dragBean = (ChangeListDragBean)attached).getTargetNode()) != null) {
            changesBrowserNode.acceptDrop(this.myChangeListManager, dragBean);
        }
    }

    public static boolean isCopyAction(@NotNull DnDEvent aEvent) {
        DnDAction eventAction = aEvent.getAction();
        return eventAction != null && eventAction.getActionId() == 1;
    }

    private boolean fitsInBounds(Rectangle rect) {
        Container scrollPane;
        Container container = this.myTree.getParent();
        if (container instanceof JViewport && (scrollPane = container.getParent()) instanceof JScrollPane) {
            Rectangle rectangle = SwingUtilities.convertRectangle((Component)this.myTree, rect, scrollPane.getParent());
            return scrollPane.getBounds().contains(rectangle);
        }
        return true;
    }

    private int getSelectionCount() {
        TreePath[] paths = this.myTree.getSelectionModel().getSelectionPaths();
        int count = 0;
        ArrayList<ChangesBrowserNode> nodes = new ArrayList<ChangesBrowserNode>();
        for (TreePath path : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
            if (node.isLeaf()) continue;
            nodes.add(node);
            count += node.getFileCount();
        }
        for (TreePath path : paths) {
            ChangesBrowserNode element = (ChangesBrowserNode)path.getLastPathComponent();
            boolean child2 = false;
            for (ChangesBrowserNode node : nodes) {
                if (!node.isNodeChild(element)) continue;
                child2 = true;
                break;
            }
            if (!child2) {
                if (!element.isLeaf()) continue;
                ++count;
                continue;
            }
            if (element.isLeaf()) continue;
            count -= element.getFileCount();
        }
        return count;
    }
}

