/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends ChangesTree
implements DataProvider,
DnDAware {
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> UNVERSIONED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> IGNORED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project, boolean showCheckboxes) {
        super(project, showCheckboxes, true);
        this.setDragEnabled(true);
    }

    @Override
    protected void installEnterKeyHandler() {
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
    }

    @Override
    protected void installDoubleClickHandler() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
    }

    @Override
    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        return new ChangesGroupingSupport(this.myProject, (Object)this, true);
    }

    @Override
    public int getToggleClickCount() {
        return 2;
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        ChangesBrowserNode<?> oldRoot = this.getRoot();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        state.applyTo((JTree)((Object)this), newRoot);
        this.expandDefaultChangeList(oldRoot, newRoot);
    }

    @Override
    public void rebuildTree() {
    }

    private void expandDefaultChangeList(ChangesBrowserNode oldRoot, ChangesBrowserNode root) {
        if (oldRoot.getFileCount() != 0) {
            return;
        }
        if (TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() != 0) {
            return;
        }
        Iterator nodes = ContainerUtil.iterate(root.children());
        ChangesBrowserNode defaultListNode = (ChangesBrowserNode)ContainerUtil.find((Iterator)nodes, node -> {
            if (node instanceof ChangesBrowserChangeListNode) {
                ChangeList list2 = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject();
                return list2 instanceof LocalChangeList && ((LocalChangeList)list2).isDefault();
            }
            return false;
        });
        if (defaultListNode == null) {
            return;
        }
        if (defaultListNode.getChildCount() == 0) {
            return;
        }
        if (defaultListNode.getChildCount() > 10000) {
            return;
        }
        this.expandPath(new TreePath(new Object[]{root, defaultListNode}));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getSelectedChanges().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return this.getLeadSelection().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return this.getSelectedChangeLists().toArray(ChangeList[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles().toArray(VirtualFile[]::new);
        }
        if (VcsDataKeys.VIRTUAL_FILE_STREAM.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle(this.getNavigatableFiles());
            return file2 != null && !file2.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file2, 0) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles());
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList)) ? new VirtualFileDeleteProvider() : null;
        }
        if (UNVERSIONED_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedUnversionedFiles();
        }
        if (IGNORED_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedIgnoredFiles();
        }
        if (VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().collect(Collectors.toList());
        }
        if (LOCALLY_DELETED_CHANGES.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().collect(Collectors.toList());
        }
        if (MISSING_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedMissingFiles().collect(Collectors.toList());
        }
        if (VcsDataKeys.HAVE_LOCALLY_DELETED.is(dataId)) {
            return this.getSelectedMissingFiles().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
            return !UtilKt.isEmpty(this.getSelectedChanges());
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Stream<VirtualFile> getUnversionedFiles() {
        Enumeration<TreeNode> nodes = this.getRoot().children();
        ChangesBrowserUnversionedFilesNode node = (ChangesBrowserUnversionedFilesNode)ContainerUtil.findInstance((Iterator)ContainerUtil.iterate(nodes), ChangesBrowserUnversionedFilesNode.class);
        if (node == null) {
            return Stream.empty();
        }
        return node.getFilesUnderStream();
    }

    @NotNull
    public Stream<VirtualFile> getSelectedUnversionedFiles() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedIgnoredFiles() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.IGNORED_FILES_TAG);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        return this.getSelectionNodesStream(tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        return this.getSelectionNodesStream(null);
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@Nullable Object tag) {
        return UtilKt.stream((Object[])this.getSelectionPaths()).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        return this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(@Nullable TreePath[] paths, @Nullable Object tag) {
        return UtilKt.stream((Object[])paths).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
    }

    static boolean isUnderTag(@NotNull TreePath path, @Nullable Object tag) {
        boolean result2 = true;
        if (tag != null) {
            result2 = path.getPathCount() > 1 && ((ChangesBrowserNode)path.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project, @Nullable TreePath[] paths) {
        Stream<Change> changes2 = UtilKt.stream((Object[])paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file2 -> ChangesListView.toHijackedChange(project, file2)).filter(Objects::nonNull);
        return Stream.concat(changes2, hijackedChanges).filter(new DistinctChangePredicate());
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file2) {
        VcsCurrentRevisionProxy before = VcsCurrentRevisionProxy.create(file2, project);
        if (before != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        return this.getSelectionNodesStream(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        return this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        return Stream.concat(ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        return Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        return this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).filter(new DistinctChangePredicate());
    }

    @NotNull
    public Stream<Change> getChanges() {
        return this.getRoot().getObjectsUnderStream(Change.class);
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        for (DefaultMutableTreeNode node = this.findNodeInTree(change); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
            if (node instanceof ChangesBrowserChangeListNode) {
                return ((ChangesBrowserChangeListNode)node).getAllChangesUnder();
            }
            if (node != this.getRoot() || !Registry.is((String)"vcs.skip.single.default.changelist")) continue;
            return this.getRoot().getAllChangesUnder();
        }
        return null;
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        return ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        return this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
    }

    @Override
    public void installPopupHandler(@NotNull ActionGroup group) {
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)group, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path != null) {
                this.setSelectionPath(path);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public DefaultMutableTreeNode findNodeInTree(Object userObject) {
        if (userObject instanceof ChangeListChange) {
            return TreeUtil.findNode(this.getRoot(), node -> ChangeListChange.HASHING_STRATEGY.equals(node.getUserObject(), userObject));
        }
        return TreeUtil.findNodeWithObject(this.getRoot(), (Object)userObject);
    }

    @Nullable
    public TreePath findNodePathInTree(Object userObject) {
        DefaultMutableTreeNode node = this.findNodeInTree(userObject);
        return node != null ? TreeUtil.getPathFromRoot((TreeNode)node) : null;
    }

    private static class DistinctChangePredicate
    implements Predicate<Change> {
        private final Set<Object> seen = ContainerUtil.newTroveSet((TObjectHashingStrategy)ChangeListChange.HASHING_STRATEGY);

        private DistinctChangePredicate() {
        }

        @Override
        public boolean test(Change change) {
            return this.seen.add(change);
        }
    }
}

