/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTree
extends Tree
implements DataProvider {
    @NotNull
    protected final Project myProject;
    private final boolean myShowCheckboxes;
    private final int myCheckboxWidth;
    @NotNull
    private final ChangesGroupingSupport myGroupingSupport;
    private boolean myIsModelFlat;
    @NotNull
    private TObjectHashingStrategy<Object> myInclusionHashingStrategy = ContainerUtil.canonicalStrategy();
    @NotNull
    private Set<Object> myIncludedChanges = new THashSet(this.myInclusionHashingStrategy);
    @NotNull
    private Runnable myDoubleClickHandler = EmptyRunnable.getInstance();
    private boolean myKeepTreeState = false;
    @Deprecated
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    @NonNls
    private static final String GROUPING_KEYS = "ChangesTree.GroupingKeys";
    public static final String[] DEFAULT_GROUPING_KEYS = (String[])ContainerUtil.ar((Object[])new String[]{"directory", "module"});
    @NonNls
    public static final String GROUP_BY_ACTION_GROUP = "ChangesView.GroupBy";
    @Nullable
    private Runnable myInclusionListener;
    @NotNull
    private final CopyProvider myTreeCopyProvider;
    @NotNull
    private TreeExpander myTreeExpander = new MyTreeExpander();
    private boolean myModelUpdateInProgress;

    public ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        this(project, showCheckboxes, highlightProblems, false);
    }

    protected ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean expandInSpeedSearch) {
        super((TreeNode)ChangesBrowserNode.createRoot());
        this.myProject = project;
        this.myShowCheckboxes = showCheckboxes;
        this.myCheckboxWidth = new JCheckBox().getPreferredSize().width;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        new TreeSpeedSearch(this, ChangesBrowserNode.TO_TEXT_CONVERTER, expandInSpeedSearch);
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.myProject, this::isShowFlatten, highlightProblems);
        this.setCellRenderer(new MyTreeCellRenderer(nodeRenderer));
        if (this.myShowCheckboxes) {
            new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this));
        }
        this.installEnterKeyHandler();
        this.installDoubleClickHandler();
        this.installTreeLinkHandler(nodeRenderer);
        SmartExpander.installOn((JTree)((Object)this));
        this.myGroupingSupport = this.installGroupingSupport();
        this.setEmptyText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.myTreeCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
    }

    protected void installEnterKeyHandler() {
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTree.this.myDoubleClickHandler.run();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode() && e.getModifiers() == 0) {
                    if (ChangesTree.this.getSelectionCount() <= 1) {
                        Object lastPathComponent = ChangesTree.this.getLastSelectedPathComponent();
                        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                            return;
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                        if (!node.isLeaf()) {
                            return;
                        }
                    }
                    ChangesTree.this.myDoubleClickHandler.run();
                    e.consume();
                }
            }
        });
    }

    protected void installDoubleClickHandler() {
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath clickPath;
                TreePath treePath = clickPath = ChangesTree.this.getUI() instanceof WideSelectionTreeUI ? ChangesTree.this.getClosestPathForLocation(e.getX(), e.getY()) : ChangesTree.this.getPathForLocation(e.getX(), e.getY());
                if (clickPath == null) {
                    return false;
                }
                int row2 = ChangesTree.this.getRowForLocation(e.getPoint().x, e.getPoint().y);
                if (row2 >= 0 && ChangesTree.this.myShowCheckboxes) {
                    Rectangle baseRect = ChangesTree.this.getRowBounds(row2);
                    baseRect.setSize(ChangesTree.this.myCheckboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        return false;
                    }
                }
                ChangesTree.this.myDoubleClickHandler.run();
                return true;
            }
        }.installOn((Component)((Object)this));
    }

    protected void installTreeLinkHandler(@NotNull ChangesBrowserNodeRenderer nodeRenderer) {
        new TreeLinkMouseListener(nodeRenderer){

            @Override
            protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path) {
                int x = super.getRendererRelativeX(e, tree, path);
                return !ChangesTree.this.myShowCheckboxes ? x : x - ChangesTree.this.myCheckboxWidth;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!ChangesTree.this.isEmpty()) {
                    super.mouseMoved(e);
                }
            }
        }.installOn((Component)((Object)this));
    }

    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        ChangesGroupingSupport result2 = new ChangesGroupingSupport(this.myProject, (Object)this, false);
        this.migrateShowFlattenSetting();
        result2.setGroupingKeysOrSkip(ContainerUtil.set((Object[])((Object[])ObjectUtils.notNull((Object)PropertiesComponent.getInstance((Project)this.myProject).getValues(GROUPING_KEYS), (Object)DEFAULT_GROUPING_KEYS))));
        result2.addPropertyChangeListener(e -> this.changeGrouping());
        return result2;
    }

    private void migrateShowFlattenSetting() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        if (properties.isValueSet(FLATTEN_OPTION_KEY)) {
            properties.setValues(GROUPING_KEYS, properties.isTrueValue(FLATTEN_OPTION_KEY) ? ArrayUtil.EMPTY_STRING_ARRAY : DEFAULT_GROUPING_KEYS);
            properties.unsetValue(FLATTEN_OPTION_KEY);
        }
    }

    public void setEmptyText(@NotNull String emptyText) {
        this.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(final @NotNull Runnable runnable2) {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                runnable2.run();
            }
        });
    }

    public void setInclusionListener(@Nullable Runnable runnable2) {
        this.myInclusionListener = runnable2;
    }

    public void setDoubleClickHandler(@NotNull Runnable doubleClickHandler) {
        this.myDoubleClickHandler = doubleClickHandler;
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)this), (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }

    public void addGroupingChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myGroupingSupport.addPropertyChangeListener(listener2);
    }

    public void removeGroupingChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myGroupingSupport.removePropertyChangeListener(listener2);
    }

    @NotNull
    public ChangesGroupingSupport getGroupingSupport() {
        return this.myGroupingSupport;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        return this.getGroupingSupport().getGrouping();
    }

    public boolean isShowFlatten() {
        return !this.myGroupingSupport.isDirectory();
    }

    public boolean isShowCheckboxes() {
        return this.myShowCheckboxes;
    }

    private void changeGrouping() {
        PropertiesComponent.getInstance((Project)this.myProject).setValues(GROUPING_KEYS, ArrayUtil.toStringArray(this.getGroupingSupport().getGroupingKeys()));
        List<Object> oldSelection = this.getSelectedUserObjects();
        this.rebuildTree();
        this.setSelectedChanges(oldSelection);
    }

    private void setChildIndent(boolean isFlat) {
        BasicTreeUI treeUI = (BasicTreeUI)this.getUI();
        treeUI.setLeftChildIndent(!isFlat ? UIUtil.getTreeLeftChildIndent() : 0);
        treeUI.setRightChildIndent(!isFlat ? UIUtil.getTreeRightChildIndent() : 0);
    }

    private boolean isCurrentModelFlat() {
        boolean isFlat = true;
        Enumeration<TreeNode> enumeration = this.getRoot().depthFirstEnumeration();
        while (isFlat && enumeration.hasMoreElements()) {
            isFlat = ((ChangesBrowserNode)enumeration.nextElement()).getLevel() <= 1;
        }
        return isFlat;
    }

    public abstract void rebuildTree();

    protected void updateTreeModel(@NotNull DefaultTreeModel model) {
        this.myModelUpdateInProgress = true;
        try {
            ApplicationManager.getApplication().assertIsDispatchThread();
            TreeState state = null;
            if (this.myKeepTreeState) {
                state = TreeState.createOn((JTree)((Object)this), this.getRoot());
            }
            this.setModel(model);
            this.myIsModelFlat = this.isCurrentModelFlat();
            this.setChildIndent(this.myGroupingSupport.isNone() && this.myIsModelFlat);
            if (this.myKeepTreeState) {
                state.applyTo((JTree)((Object)this), this.getRoot());
            } else {
                this.resetTreeState();
            }
        }
        finally {
            this.myModelUpdateInProgress = false;
        }
    }

    public boolean isModelUpdateInProgress() {
        return this.myModelUpdateInProgress;
    }

    protected void resetTreeState() {
        TreeUtil.expandAll((JTree)((Object)this));
        int selectedTreeRow = -1;
        if (this.myShowCheckboxes && !this.getIncludedSet().isEmpty()) {
            ChangesBrowserNode node;
            ChangesBrowserNode<?> root = this.getRoot();
            Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (node == root || this.getNodeStatus(node) != ThreeStateCheckBox.State.NOT_SELECTED) continue;
                this.collapsePath(new TreePath(node.getPath()));
            }
            enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (!node.isLeaf() || this.getNodeStatus(node) != ThreeStateCheckBox.State.SELECTED) continue;
                selectedTreeRow = this.getRowForPath(new TreePath(node.getPath()));
                break;
            }
        }
        if (selectedTreeRow >= 0) {
            this.setSelectionRow(selectedTreeRow);
        }
        TreeUtil.showRowCentered((JTree)((Object)this), (int)selectedTreeRow, (boolean)false);
    }

    public void selectFile(@Nullable VirtualFile toSelect2) {
        if (toSelect2 == null) {
            return;
        }
        this.selectFile(VcsUtil.getFilePath((VirtualFile)toSelect2));
    }

    public void selectFile(@Nullable FilePath toSelect2) {
        if (toSelect2 == null) {
            return;
        }
        int rowInTree = this.findRowContainingFile(this.getRoot(), toSelect2);
        if (rowInTree == -1) {
            return;
        }
        this.setSelectionRow(rowInTree);
        TreeUtil.showRowCentered((JTree)((Object)this), (int)rowInTree, (boolean)false);
    }

    private int findRowContainingFile(@NotNull TreeNode root, @NotNull FilePath toSelect2) {
        Ref row2 = Ref.create((Object)-1);
        TreeUtil.traverse((TreeNode)root, node -> {
            Object userObject;
            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change && ChangesTree.matches((Change)userObject, toSelect2)) {
                Object[] path = ((DefaultMutableTreeNode)node).getPath();
                row2.set((Object)this.getRowForPath(new TreePath(path)));
            }
            return (Integer)row2.get() == -1;
        });
        return (Integer)row2.get();
    }

    private static boolean matches(@NotNull Change change, @NotNull FilePath toSelect2) {
        return toSelect2.equals(ChangesUtil.getAfterPath((Change)change));
    }

    @NotNull
    private List<Object> getAllUserObjects() {
        return VcsTreeModelData.all((JTree)((Object)this)).userObjects();
    }

    @NotNull
    private List<Object> getUserObjectsUnder(@NotNull ChangesBrowserNode<?> node) {
        return VcsTreeModelData.children(node).userObjects();
    }

    @NotNull
    private List<Object> getSelectedUserObjects() {
        return VcsTreeModelData.selected((JTree)((Object)this)).userObjects();
    }

    @NotNull
    ChangesBrowserNode<?> getRoot() {
        return (ChangesBrowserNode)this.getModel().getRoot();
    }

    protected void notifyInclusionListener() {
        if (this.myInclusionListener != null) {
            this.myInclusionListener.run();
        }
    }

    public void setInclusionHashingStrategy(@NotNull TObjectHashingStrategy<Object> strategy) {
        this.myInclusionHashingStrategy = strategy;
        Set<Object> oldInclusion = this.myIncludedChanges;
        this.myIncludedChanges = new THashSet(strategy);
        this.myIncludedChanges.addAll(oldInclusion);
    }

    public void setIncludedChanges(@NotNull Collection<?> changes2) {
        this.myIncludedChanges.clear();
        this.myIncludedChanges.addAll(changes2);
        this.repaint();
    }

    public void includeChange(Object change) {
        this.includeChanges(Collections.singleton(change));
    }

    public void includeChanges(Collection<?> changes2) {
        this.myIncludedChanges.addAll(changes2);
        this.notifyInclusionListener();
        this.repaint();
    }

    public void excludeChange(Object change) {
        this.excludeChanges(Collections.singleton(change));
    }

    public void excludeChanges(Collection<?> changes2) {
        this.myIncludedChanges.removeAll(changes2);
        this.notifyInclusionListener();
        this.repaint();
    }

    protected void toggleChanges(Collection<?> changes2) {
        boolean hasExcluded = false;
        for (Object value : changes2) {
            if (this.myIncludedChanges.contains(value)) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeChanges(changes2);
        } else {
            this.excludeChanges(changes2);
        }
    }

    public boolean isIncluded(Object change) {
        return this.myIncludedChanges.contains(change);
    }

    @NotNull
    public Set<Object> getIncludedSet() {
        return new THashSet(this.myIncludedChanges, this.myInclusionHashingStrategy);
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void setTreeExpander(@NotNull TreeExpander expander) {
        this.myTreeExpander = expander;
    }

    @Deprecated
    public AnAction[] getTreeActions() {
        return new AnAction[]{ActionManager.getInstance().getAction(GROUP_BY_ACTION_GROUP), this.createExpandAllAction(false), this.createCollapseAllAction(false)};
    }

    @NotNull
    public AnAction createExpandAllAction(boolean headerAction) {
        if (headerAction) {
            return CommonActionsManager.getInstance().createExpandAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
        }
        return CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
    }

    @NotNull
    public AnAction createCollapseAllAction(boolean headerAction) {
        if (headerAction) {
            return CommonActionsManager.getInstance().createCollapseAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
        }
        return CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    protected ThreeStateCheckBox.State getNodeStatus(@NotNull ChangesBrowserNode<?> node) {
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (Object change : this.getUserObjectsUnder(node)) {
            if (this.myIncludedChanges.contains(change)) {
                hasIncluded = true;
                continue;
            }
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            return ThreeStateCheckBox.State.DONT_CARE;
        }
        if (hasIncluded) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        return ThreeStateCheckBox.State.NOT_SELECTED;
    }

    protected boolean isNodeEnabled(ChangesBrowserNode<?> node) {
        return true;
    }

    public void setSelectedChanges(@NotNull Collection<?> changes2) {
        HashSet changesSet = new HashSet(changes2);
        ArrayList treeSelection = new ArrayList(changes2.size());
        TreeUtil.traverse(this.getRoot(), node -> {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
            if (changesSet.contains(mutableNode.getUserObject())) {
                treeSelection.add(new TreePath(mutableNode.getPath()));
            }
            return true;
        });
        this.setSelectionPaths(treeSelection.toArray(new TreePath[0]));
        if (treeSelection.size() == 1) {
            this.scrollPathToVisible((TreePath)treeSelection.get(0));
        }
    }

    public void setKeepTreeState(boolean keepTreeState) {
        this.myKeepTreeState = keepTreeState;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myTreeCopyProvider;
        }
        if (ChangesGroupingSupport.KEY.is(dataId)) {
            return this.myGroupingSupport;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        return null;
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public Color getFileColorFor(Object object) {
        VirtualFile file2 = object instanceof FilePath ? ChangesTree.getVirtualFileFor((FilePath)object) : (object instanceof Change ? ChangesTree.getVirtualFileFor(ChangesUtil.getFilePath((Change)((Change)object))) : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class));
        if (file2 != null) {
            return VfsPresentationUtil.getFileBackgroundColor(this.myProject, file2);
        }
        return super.getFileColorFor(object);
    }

    @Nullable
    private static VirtualFile getVirtualFileFor(@NotNull FilePath filePath) {
        if (filePath.isNonLocal()) {
            return null;
        }
        return ChangesUtil.findValidParentAccurately((FilePath)filePath);
    }

    protected void processMouseEvent(MouseEvent e) {
        int row2;
        if (e.getID() == 501 && this.myShowCheckboxes && this.isEnabled() && !e.isPopupTrigger() && (row2 = this.getRowForLocation(e.getX(), e.getY())) >= 0) {
            Rectangle baseRect = this.getRowBounds(row2);
            baseRect.setSize(this.myCheckboxWidth, baseRect.height);
            if (baseRect.contains(e.getPoint())) {
                this.setSelectionRow(row2);
                this.toggleChanges(this.getSelectedUserObjects());
            }
        }
        super.processMouseEvent(e);
    }

    public int getToggleClickCount() {
        return -1;
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List changes2 = ChangesTree.this.getSelectedUserObjects();
            if (changes2.isEmpty()) {
                changes2 = ChangesTree.this.getAllUserObjects();
            }
            ChangesTree.this.toggleChanges(changes2);
        }
    }

    private class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final ChangesBrowserNodeRenderer myTextRenderer;
        private final ThreeStateCheckBox myCheckBox;

        MyTreeCellRenderer(ChangesBrowserNodeRenderer textRenderer) {
            super(new BorderLayout());
            this.myCheckBox = new ThreeStateCheckBox();
            this.myTextRenderer = textRenderer;
            if (ChangesTree.this.myShowCheckboxes) {
                this.add((Component)this.myCheckBox, "West");
            }
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            this.setBackground(null);
            this.myCheckBox.setBackground(null);
            this.myCheckBox.setOpaque(false);
            this.myTextRenderer.setOpaque(false);
            this.myTextRenderer.setTransparentIconBackground(true);
            this.myTextRenderer.setToolTipText(null);
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row2, hasFocus);
            if (ChangesTree.this.myShowCheckboxes) {
                ThreeStateCheckBox.State state = ChangesTree.this.getNodeStatus((ChangesBrowserNode)value);
                this.myCheckBox.setState(state);
                this.myCheckBox.setEnabled(tree.isEnabled() && ChangesTree.this.isNodeEnabled((ChangesBrowserNode)value));
                this.revalidate();
                return this;
            }
            return this.myTextRenderer;
        }

        @Override
        public String getToolTipText() {
            return this.myTextRenderer.getToolTipText();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContextDelegate(this.myCheckBox.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return MyTreeCellRenderer.this.getParent();
                    }

                    public String getAccessibleName() {
                        MyTreeCellRenderer.this.myCheckBox.getAccessibleContext().setAccessibleName(MyTreeCellRenderer.this.myTextRenderer.getAccessibleContext().getAccessibleName());
                        return MyTreeCellRenderer.this.myCheckBox.getAccessibleContext().getAccessibleName();
                    }

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.LABEL;
                    }
                };
                return this.accessibleContext;
            }
            return this.accessibleContext;
        }
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        MyTreeExpander() {
            super((JTree)((Object)ChangesTree.this));
        }

        public boolean isVisible(@NotNull AnActionEvent event) {
            return !ChangesTree.this.myGroupingSupport.isNone() || !ChangesTree.this.myIsModelFlat;
        }
    }
}

